.TH Scene 3I "7 Mar 1989" "InterViews" "InterViews Reference Manual"
.SH NAME
Scene, MonoScene \- composite interactors
.SH SYNOPSIS
.B #include <InterViews/scene.h>
.SH DESCRIPTION
.B Scene
is the base class for all interactors
that are defined in terms of one or more instances of other interactors.
.B MonoScene
is a subclass for scenes that contain a single instance.
A monoscene's shape is copied from its component and
the component's canvas is given the same size and location
as the monoscene's canvas.
.PP
When a scene is deleted, it should delete all its component interactors.
A monoscene deletes its existing component
if a new component is inserted.
.SH PUBLIC OPERATIONS
.TP
.B "void Insert(Interactor*)"
.ns
.TP
.B "void Insert(Interactor*, Coord x, Coord y, Alignment = BottomLeft)"
.ns
.TP
.B "virtual Interactor* Wrap(Interactor*)"
.ns
.TP
.B "virtual void DoInsert(Interactor*, boolean, Coord& x, Coord& y, Shape*)"
Add an interactor to the scene, optionally aligned with respect to a
specific position relative to the lower-left corner of the scene.
Valid alignment types are TopLeft, TopCenter, TopRight, CenterLeft,
Center, CenterRight, BottomLeft, BottomCenter, BottomRight, Left,
Right, Top, Bottom, HorizCenter, and VertCenter.  The scene uses the
interactor's desired shape, if it has non-zero width, to size the
interactor.  The base scene class always calls Wrap and DoInsert from
Insert; thus subclasses only implement DoInsert (and Wrap if they want
to wrap additional interactors around the inserted interactor) and
users only call Insert.  In the case of a monoscene, the current
interior interactor, if not nil, is deleted and replaced by the given
interactor.  If an interactor is inserted into a scene that is already
mapped, the interactor and its descendants will be configured before
DoInsert is called.
.TP
.B "void Propagate(boolean)"
.ns
.TP
.B "void Change(Interactor*)"
.ns
.TP
.B "virtual void DoChange(Interactor*, Shape*)"
Change notifies a scene that a given interactor has changed
its desired shape.
If the propagate flag associated with the scene is true, Change will call
DoChange and then Change(this) on the scene's parent.
If the propagate flag is false, Resize will be called instead.
The propagate flag is true by default and
can be set with the Propagate operation.
.TP
.B "void Move(Interactor*, Coord x, Coord y, Alignment = BottomLeft)"
.ns
.TP
.B "virtual void DoMove(Interactor*, Coord& x, Coord& y)"
Request that an interactor be moved to the given coordinates using the
given alignment.  As with Insert and Change, users call Move and
subclasses implement DoMove.
.TP
.B "void Remove(Interactor*)"
.ns
.TP
.B "virtual void DoRemove(Interactor*)"
Remove an interactor from a scene.
Users call Remove and subclasses implement DoRemove.
.TP
.B "void Lower(Interactor*)"
.ns
.TP
.B "virtual void DoLower(Interactor*)"
Put the interactor's canvas below all others in the scene,
potentially obscuring it.
Users call Lower and subclasses implement DoLower.
.TP
.B "void Raise(Interactor*)"
.ns
.TP
.B "virtual void DoRaise(Interactor*)"
Put the interactor's canvas above all others in the scene,
making it fully visible.
Users call Raise and subclasses implement DoRaise.
.SH PROTECTED OPERATIONS
.TP
.B "Scene()"
.ns
.TP
.B "MonoScene()"
Construct a new scene or monoscene.
Scenes and monoscenes are abstract classes;
thus,
the constructors should only be called implicitly by subclass constructors.
.TP
.B "void Place(Interactor*, Coord x1, Coord y1, Coord x2, Coord y2, boolean = true)"
Assign an interactor's canvas to be a given region of the scene's canvas.
Unless the optional sixth parameter is false,
the interactor will be mapped.
If the interactor is already assigned the given position and size,
then this operation will have no effect.
This optimization means that a scene can place all of its elements
in response to a Change and be assured that only those elements
that have really changed will be redrawn.
.TP
.B "void Map(Interactor*, boolean = true)"
Make the interactor visible on the display if and when the scene is visible.
Unless the optional second parameter is false,
the interactor will be raised to the top of the scene.
.TP
.B "void Unmap(Interactor*)"
Make the interactor not be visible on the display if and
when the scene is visible.
.TP
.B "void UserPlace(Interactor*, int w, int h)"
Let the user interact with the window manager to specify the size and
location of the interactor's canvas, whose default width and height
must also be supplied by the program.
.SH SEE ALSO
Canvas(3I), Interactor(3I), Shape(3I)
