function MenuCheckOnClick(){
	var el = window.event.srcElement;
	var xmlEl = checkBoxTree.selectSingleNode("//input[@id='" + el.id + "']");
	
	if(el.checked == true){
		xmlEl.setAttribute("checked", "true");
	}
	else{
		xmlEl.setAttribute("checked", "false");
	}

	// check siblings.  If all checked, then check the parent too
	if(xmlEl.getAttribute("ParentID") != ""){	// if not root
		MenuCheckParent(checkBoxTree.selectSingleNode("//input[@id='" + el.ParentID + "']"));
	}

	// check all children
	MenuCheckChildren(xmlEl);
}

// check all the children
function MenuCheckChildren(el){
	if(el == null){
		return;
	}

	var childNode = null;
	var checkStatus;

	if(el.getAttribute("checked") == "true"){
		checkStatus = true;
	}
	else{
		checkStatus = false;
	}

	var childNodes = el.childNodes;
	var nodesCount = childNodes.length;

	if(nodesCount == 0){
		return;
	}

	var curIndex = 0;
	for(curIndex = 0; curIndex < nodesCount; curIndex++){
		childNode = childNodes[curIndex];
		
		childNode.setAttribute("checked", el.getAttribute("checked"));
		document.all.item(childNode.getAttribute("id")).checked = checkStatus;
		
		MenuCheckChildren(childNode);
	}
}

// check all siblings.  If all are checked, then set the parent to 'on'
function MenuCheckParent(el){
	if(el == null){
		return;
	}

	var parentID = el.getAttribute("id");

	var uncheckedNodes = checkBoxTree.selectNodes("//input[@ParentID='" + parentID + "' && @checked='false']");

	if(uncheckedNodes.length > 0){
		el.setAttribute("checked", "false");
		document.all.item(parentID).checked = false;
	}
	else{
		el.setAttribute("checked", "true");
		document.all.item(parentID).checked = true;
	}
	
	MenuCheckParent(checkBoxTree.selectSingleNode("//input[@id='" + el.getAttribute("ParentID") + "']"));
}

function MenuOnMouseOver(){
	var el = window.event.srcElement;
	el.style.color='red';
}

function MenuOnMouseOut(){
	var el = window.event.srcElement;
	el.style.color='black';
}

function MenuIconOnClick(){
	var el = window.event.srcElement;
	var elID = el.id;
	var childID = elID.replace('ico_', 'sub_');
	var childRow = document.all(childID);
	
	if(childRow == null){
		return;
	}
	
	if(childRow.style.display == 'none'){
		childRow.style.display = '';
		el.src = (el.src).replace('Closed_icon', 'Opened_icon');
	}
	else{
		childRow.style.display = 'none';
		el.src = el.src.replace('Opened_icon', 'Closed_icon');
	}
}
