USE GsEventLogGathererDB
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertDelete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AlertDelete]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertHdrGet]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AlertHdrGet]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertHdrSetStatus]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AlertHdrSetStatus]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertHdrUpdate]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AlertHdrUpdate]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertItemMetaDataAdd]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AlertItemMetaDataAdd]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertListGet]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AlertListGet]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertRecipientRemove]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AlertRecipientRemove]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertRecipientUpdate]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AlertRecipientUpdate]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertScheduleGet]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AlertScheduleGet]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertsExecute]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AlertsExecute]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AppUserAdd]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AppUserAdd]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AppUserDelete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AppUserDelete]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AppUserEdit]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AppUserEdit]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AppUserInfoGet]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AppUserInfoGet]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AppUserListGet]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AppUserListGet]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AppUserLogin]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AppUserLogin]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AppUserPasswordChange]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AppUserPasswordChange]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[EventCategoryListGet]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EventCategoryListGet]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[EventExclusionDelete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EventExclusionDelete]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[EventExclusionGridGet]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EventExclusionGridGet]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[EventExclusionInsert]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EventExclusionInsert]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[EventTypeListGet]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EventTypeListGet]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[LogEntriesClear]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[LogEntriesClear]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[LogEntriesClearAll]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[LogEntriesClearAll]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[LogEntryExclusionCheck]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[LogEntryExclusionCheck]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[LogEntryInsert]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[LogEntryInsert]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[LogEntryPageDetailsGet]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[LogEntryPageDetailsGet]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[LogEntryTop1000Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[LogEntryTop1000Delete]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[MenuServerListGet]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[MenuServerListGet]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SavedReportDelete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SavedReportDelete]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SavedReportGet]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SavedReportGet]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SavedReportHdrMake]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SavedReportHdrMake]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SavedReportListGet]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SavedReportListGet]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SavedReportMetaDataAdd]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SavedReportMetaDataAdd]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ServerAdd]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ServerAdd]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ServerDelete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ServerDelete]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ServerDisable]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ServerDisable]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ServerListGet]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ServerListGet]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SourceNameListGet]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SourceNameListGet]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[VersionInfoGet]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[VersionInfoGet]
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO



CREATE PROC dbo.AlertDelete
(
	@AlertHdrID INT
)
AS	
	IF NOT EXISTS (SELECT AlertHdrID FROM AlertHdr WHERE AlertHdrID = @AlertHdrID) BEGIN

		RETURN (-207)
	END

	-- delete alert schedule
	DELETE	AlertSchedule
	WHERE	AlertHdrID = @AlertHdrID

	DELETE	AlertItem
	WHERE	AlertHdrID = @AlertHdrID

	DELETE	AlertHdr
	WHERE	AlertHdrID = @AlertHdrID

	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO


CREATE PROC dbo.AlertHdrGet
(
	@AlertHdrID	INT
)
AS
	SELECT	ah.AlertHdrID
		,ah.AlertDesc
		,ai.AlertItemMetaData
	FROM	AlertHdr ah
		,AlertItem ai
	WHERE	ah.AlertHdrID = @AlertHdrID
		AND ah.AlertHdrID = ai.AlertHdrID
	ORDER BY
		ai.AlertItemID

	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO



CREATE PROC dbo.AlertHdrSetStatus
(
	@AlertHdrID 	INT
	,@AlertSql	VARCHAR(7000) = NULL
	,@StatusFlag 	tinyint
)
AS	
	IF NOT EXISTS (SELECT AlertHdrID FROM AlertHdr WHERE AlertHdrID = @AlertHdrID) BEGIN

		RETURN (-207)
	END

	UPDATE	AlertHdr
	SET	Status = @StatusFlag
		,AlertSql = @AlertSql
	WHERE	AlertHdrID = @AlertHdrID

	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO


CREATE PROC dbo.AlertHdrUpdate
(
	@AlertHdrID			INT OUTPUT
	,@AppUserID			INT
	,@AlertDesc			VARCHAR(255) = NULL
)
AS
	-- check if the report description exists already
	SELECT	AlertHdrID
	FROM	AlertHdr
	WHERE	AlertHdrID = @AlertHdrID

	IF @@ROWCOUNT > 0 BEGIN -- update existing records
		-- remove existing metadata
		DELETE AlertItem WHERE AlertHdrID = @AlertHdrID

		IF @AlertDesc <> '' BEGIN
			-- update the Hdr info
			UPDATE	AlertHdr
			SET	AppUserName = au.AppUserName
				,AlertDesc = @AlertDesc
			FROM	AppUser au
			WHERE	AlertHdrID = @AlertHdrID
				AND au.AppUserID = @AppUserID
		END
		ELSE BEGIN
			-- update the Hdr info
			UPDATE	AlertHdr
			SET	AppUserName = au.AppUserName
			FROM	AppUser au
			WHERE	AlertHdrID = @AlertHdrID
				AND au.AppUserID = @AppUserID
		END 
	END
	ELSE BEGIN -- insert new record
		INSERT	AlertHdr
			(AppUserName, AlertDesc, Status)
		SELECT	au.AppUserName
			,@AlertDesc
			,0
		FROM	AppUser au
		WHERE	au.AppUserID = @AppUserID
		
		-- get the newly created user id
		SET @AlertHdrID = @@IDENTITY
	END


	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO


CREATE PROC dbo.AlertItemMetaDataAdd
(
	@AlertHdrID		INT
	,@AlertItemID		INT
	,@AlertItemMetaData	VARCHAR(1023)
)
AS
	-- check if the header exists
	SELECT	AlertHdrID
	FROM	AlertHdr
	WHERE	AlertHdrID = @AlertHdrID

	IF @@ROWCOUNT = 0
		RETURN 206	-- no header
	
	INSERT	AlertItem
		(AlertHdrID, AlertItemID, AlertItemMetaData)
		VALUES(@AlertHdrID, @AlertItemID, @AlertItemMetaData)

	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO



CREATE PROC dbo.AlertListGet
AS
	SELECT	AlertHdrID
		,AppUserName
		,AlertDesc
	FROM	AlertHdr
	WHERE	Status = 1
	ORDER By AlertDesc

	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO


CREATE PROC dbo.AlertRecipientRemove
(
	@AlertHdrID		INT
	,@AlertRecipientID	INT
)
AS
	DELETE	AlertSchedule
	WHERE
		AlertHdrID = @AlertHdrID
		AND AlertRecipientID = 	@AlertRecipientID
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO


CREATE PROC dbo.AlertRecipientUpdate
(
	@AlertRecipientID		INT 
	,@AlertHdrID			INT
	,@Email				VARCHAR(50)
	,@ScheduleStartTime		DATETIME
	,@ScheduleEndTime		DATETIME
	,@ScheduleTimeDisplay		VARCHAR(50)
	,@ScheduleDaysMeta		INT
	,@ScheduleDaysDisplay		VARCHAR(50)
)
AS
	-- check if the report description exists already
	SELECT	AlertHdrID
	FROM	AlertSchedule
	WHERE	AlertHdrID = @AlertHdrID
		AND AlertRecipientID = @AlertRecipientID

	-- return error if inserting new record with the same email address
	IF @AlertRecipientID IS NULL BEGIN
		IF EXISTS(	SELECT 	1 
				FROM 	AlertSchedule
				WHERE 	AlertHdrID = @AlertHdrID
					AND Email = @Email
			)

		RETURN(-204)
	END

	IF NOT @AlertRecipientID IS NULL BEGIN -- update existing records
		-- update the Hdr info
		UPDATE	AlertSchedule
		SET	Email = @Email
			,ScheduleStartTime = @ScheduleStartTime
			,ScheduleStartTimeMinutes = DATEPART(hour, @ScheduleStartTime)*60+DATEPART(minute, @ScheduleStartTime)
			,ScheduleEndTime = @ScheduleEndTime
			,ScheduleEndTimeMinutes = DATEPART(hour, @ScheduleEndTime)*60+DATEPART(minute, @ScheduleEndTime)
			,ScheduleTimeDisplay = @ScheduleTimeDisplay
			,ScheduleDaysMeta = @ScheduleDaysMeta
			,ScheduleDaysDisplay = @ScheduleDaysDisplay
		WHERE	AlertHdrID = @AlertHdrID
			AND AlertRecipientID = @AlertRecipientID
	END
	ELSE BEGIN -- insert new record
		SELECT 	@AlertRecipientID = ISNULL (MAX(AlertRecipientID)+1, 1)
		FROM	AlertSchedule
		WHERE	AlertHdrID = @AlertHdrID

		INSERT	AlertSchedule
			(
			AlertHdrID
			,AlertRecipientID
			,Email
			,ScheduleDaysMeta
			,ScheduleDaysDisplay
			,ScheduleStartTime
			,ScheduleEndTime
			,ScheduleTimeDisplay
			)
		VALUES	(@AlertHdrID
			,@AlertRecipientID
			,@Email
			,@ScheduleDaysMeta
			,@ScheduleDaysDisplay
			,@ScheduleStartTime
			,@ScheduleEndTime
			,@ScheduleTimeDisplay
			)
					
	END

	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO


CREATE PROC dbo.AlertScheduleGet
(
	@AlertHdrID	INT
)
AS
	
	SELECT
		AlertHdrID
		,AlertRecipientID
		,Email
		,ScheduleDaysMeta
		,ScheduleDaysDisplay
		,ISNULL((DATEPART(hour, ScheduleStartTime)%12), '')AS StartHour
		,ISNULL(DATEPART(minute, ScheduleStartTime), '')AS StartMinute
		,ISNULL(CASE WHEN DATEPART(hour, ScheduleStartTime) > 12 THEN 'PM' ELSE 'AM' END, '')AS StartAmPm
		,ISNULL((DATEPART(hour, ScheduleEndTime)%12), '')AS EndHour
		,ISNULL(DATEPART(minute, ScheduleEndTime), '')AS EndMinute
		,ISNULL(CASE WHEN DATEPART(hour, ScheduleEndTime) > 12 THEN 'PM' ELSE 'AM' END, '')AS EndAmPm
		,ScheduleTimeDisplay
	FROM
		AlertSchedule
	WHERE
		AlertHdrID = @AlertHdrID
	
	IF @@ROWCOUNT = 0 
		RETURN(-207)
	
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO


/*
sproc:		AlertsExecute
versions:	1.5
author: 	chriss
date:		12/5/2002
description:	1) Retrieves the list of alerts and alerts recipients available
		for the current time. (AlertHdr, AlertRecipient)
		2) Generates the alert querie for all recipients (AlertHdr)
		3) exectues every query, inserting entries to AlertInstance (cursor)
host:		This procedure is executed by LogEntry_ins trigger
Side effects:	AlertInstance_ins trigger is executed, sending the emails
*/
CREATE PROC dbo.AlertsExecute
(
	@LEID	INT
)
AS

	DECLARE cur1 CURSOR
	FOR
	select	ah.AlertHdrID
		,als.AlertRecipientID
		,
		'INSERT AlertInstance (AlertHdrID, AlertRecipientID, EmailSubject, EmailTo, LEID, EmailBody)'
		+'SELECT '
		+ CONVERT(VARCHAR(10), ah.AlertHdrID) + ' AS AlertHdrID,'
		+ CONVERT(VARCHAR(10), als.AlertRecipientID) + ' AS AlertRecipientID,'''
		+ ah.AlertDesc
		+ ''' As EmailSubject'
		+ ',''' + Email + ''' AS EmailTo'
		+ ',d.LEID,''Server: ''+s.ELServerName+char(13)
		+''Log: ''+lt.LogTypeName+char(13)
		+''Time: ''+CONVERT(VARCHAR(50),le.TimeGenerated)+char(13)
		+''ID: ''+CONVERT(VARCHAR(50),le.EventID)+char(13)
		+''Type: ''+et.EventTypeName+char(13)
		+''Category: ''+ec.EventCategoryName+char(13)
		+''User: ''+elu.ELUserName+char(13)
		+''Source: ''+els.ELSourceName+char(13)
		+''Description: ''+REPLACE(le.FullMessage,''<BR>'',char(13))+char(13)
		 As EmailBody 
		FROM
			(SELECT LEID FROM LogEntry WHERE LEID=' + CONVERT(VARCHAR(10),@LEID) 
			+ CASE WHEN AlertSql = '' THEN '' ELSE ' AND ' + AlertSql END + ')d 
			,LogEntry le
			,ELServer s
			,LogType lt
			,EventType et
			,EventCategory ec
			,ELUser elu
			,ELSource els 
		WHERE	le.LEID = d.LEID
			AND le.ELServerID = s.ELServerID
			AND le.LogTypeID = lt.LogTypeID
			AND le.EventTypeID = et.EventTypeID
			AND le.EventCategoryID = ec.EventCategoryID
			AND le.ELUserID = elu.ELUserID
			AND le.ELSourceID = els.ELSourceID ' AS qry
	FROM	AlertHdr ah
		INNER JOIN AlertSchedule als ON als.AlertHdrID = ah.AlertHdrID
	WHERE	Status = 1
		AND (power(2,DATEPART(weekday, GetDate())-1)) & ScheduleDaysMeta > 0
		AND 
		(
		ScheduleStartTime IS NULL AND ScheduleEndTime IS NULL
		OR
			ScheduleStartTimeMinutes < ScheduleEndTimeMinutes 
			AND 
				DATEPART(hour,GetDate())*60+DATEPART(minute,GetDate()) BETWEEN ScheduleStartTimeMinutes AND ScheduleEndTimeMinutes 
		OR 
			ScheduleStartTimeMinutes > ScheduleEndTimeMinutes 
			AND 
				(DATEPART(hour,GetDate())*60+DATEPART(minute,GetDate()) BETWEEN ScheduleStartTimeMinutes AND 24*60 
				OR 
				DATEPART(hour,GetDate())*60+DATEPART(minute,GetDate()) BETWEEN 0 AND ScheduleEndTimeMinutes )
		)

	OPEN cur1
	
	DECLARE @AlertHdrID		INT
	DECLARE @AlertRecipientID 	INT
	DECLARE @qry 			NVARCHAR(4000)
	
	FETCH NEXT FROM cur1 INTO @AlertHdrID, @AlertRecipientID, @qry
	
	WHILE @@FETCH_STATUS = 0 BEGIN
		--INSERT AlertInstance (AlertHdrID, AlertRecipientID, EmailSubject, EmailTo, LEID, EmailBody)
		EXEC sp_executesql @qry
	
		FETCH NEXT FROM cur1 INTO @AlertHdrID, @AlertRecipientID, @qry
	END
	
	close cur1
	deallocate cur1

	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.AppUserAdd
(
	@AppUserID		INT OUTPUT
	,@AppUserName		VARCHAR(50)
	,@AppUserFirstName	VARCHAR(50)
	,@AppUserLastName	VARCHAR(50)
	,@AppUserPassword	VARCHAR(20)
	,@AppRoleID		INT
)
AS
	-- check if the user is in the table already
	SELECT	AppUserID
	FROM	AppUser
	WHERE	AppUserName = @AppUserName
	IF @@ROWCOUNT > 0
		RETURN 204	-- record exists
	
	INSERT	AppUser
		(AppUserName, AppUserFirstName, AppUserLastName, AppUserPassword)
		VALUES(@AppUserName, @AppUserFirstName, @AppUserLastName, @AppUserPassword)
	SET @AppUserID = @@IDENTITY
	-- update role info
	DELETE AppUserRole WHERE AppUserID = @AppUserID
	INSERT AppUserRole (AppUserID, AppRoleID) VALUES(@AppUserID, @AppRoleID)
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.AppUserDelete
(
	@AppUserID		INT
)
AS
	DELETE	SavedReportItem
	FROM	SavedReportHdr srh
	WHERE	srh.SavedReportHdrID = SavedReportItem.SavedReportHdrID
		AND srh.AppUserID = @AppUserID
	DELETE	SavedReportHdr
	WHERE	AppUserID  = @AppUserID
	DELETE	AppUserRole
	WHERE	AppUserID = @AppUserID
	DELETE	AppUser
	WHERE	AppUserID = @AppUserID
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.AppUserEdit
(
	@AppUserID		INT
	,@AppUserFirstName	VARCHAR(50)
	,@AppUserLastName	VARCHAR(50)
	,@AppUserPassword	VARCHAR(20) = NULL
	,@AppRoleID		INT
)
AS	
	IF @AppUserPassword IS NULL
		UPDATE	AppUser
		SET	AppUserFirstName = @AppUserFirstName, AppUserLastName = @AppUserLastName
		WHERE	AppUserID = @AppUserID
	ELSE
		UPDATE	AppUser
		SET	AppUserFirstName = @AppUserFirstName, AppUserLastName = @AppUserLastName, AppUserPassword = @AppUserPassword
		WHERE	AppUserID = @AppUserID
	-- update role info
	DELETE AppUserRole WHERE AppUserID = @AppUserID
	INSERT AppUserRole (AppUserID, AppRoleID) VALUES(@AppUserID, @AppRoleID)
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.AppUserInfoGet
(
	@AppUserID		INT
)
AS
	SELECT	au.AppUserID
		,au.AppUserName
		,au.AppUserFirstName
		,au.AppUserLastName
		,au.AppUserPassword
		,aur.AppRoleID
		,ar.AppRoleName
	FROM	AppUser au
		,AppUserRole aur
		,AppRole ar
	WHERE	au.AppUserID = @AppUserID
		AND au.AppUserID = aur.AppUserID
		AND ar.AppRoleID = aur.AppRoleID
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.AppUserListGet
AS
	SELECT	au.AppUserID
		,au.AppUserName
		,au.AppUserFirstName
		,au.AppUserLastName
		,au.AppUserPassword
		,aur.AppRoleID
		,ar.AppRoleName
	FROM	AppUser au
		,AppUserRole aur
		,AppRole ar
	WHERE	au.AppUserID = aur.AppUserID
		AND aur.AppRoleID = ar.AppRoleID
	ORDER By ar.AppRoleID, au.AppUserLastName
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.AppUserLogin
(
	@AppUserID		INT OUTPUT
	,@AppRoleID		INT OUTPUT
	,@AppUserName		VARCHAR(50)
	,@AppUserPassword	VARCHAR(20)
)
AS
	-- check if the user is in the table already
	SELECT	@AppUserID = au.AppUserID
		,@AppRoleID = aur.AppRoleID
	FROM	AppUser au
		,AppUserRole aur
	WHERE	au.AppUserName = @AppUserName
		AND au.AppUserPassword = @AppUserPassword
		AND au.AppUserID = aur.AppUserID
	IF @@ROWCOUNT = 0
		RETURN 205	-- no records
	
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.AppUserPasswordChange
(
	@AppUserID		INT
	,@AppUserPassword	VARCHAR(20) = NULL
)
AS
	SELECT	AppUserID
	FROM	AppUser
	WHERE	AppUserID = @AppUserID
	IF @@ROWCOUNT = 0
		-- invalid user id
		RETURN (205)
	UPDATE	AppUser
	SET	AppUserPassword = @AppUserPassword
	WHERE	AppUserID = @AppUserID
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.EventCategoryListGet
AS
SELECT	EventCategoryID
	,EventCategoryName
FROM	EventCategory
ORDER BY
	EventCategoryName

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.EventExclusionDelete
(
	@ELServerID		INT
	,@EventTypeID		INT
)
AS
	DELETE	EventExclusion
	WHERE	ELServerID = @ELServerID
		AND EventTypeID = @EventTypeID

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.EventExclusionGridGet
AS
SELECT	els.ELServerID
	,els.ELServerName
	,et.EventTypeID
	,et.EventTypeName
	,IsChecked = CASE WHEN ee.EventTypeID IS NULL THEN 'CHECKED' ELSE '' END
FROM	EventType et
	,ELServer els
	,EventExclusion ee
WHERE	els.Status = 1
	AND els.ELServerID *= ee.ELServerID
	AND et.EventTypeID *= ee.EventTypeID
ORDER BY
	els.ELServerName
	,et.EventTypeID
RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.EventExclusionInsert
(
	@ELServerID		INT
	,@EventTypeID		INT
)
AS
	-- check if the row is in the table already
	SELECT	ELServerID
	FROM	EventExclusion
	WHERE	ELServerID = @ELServerID AND EventTypeID = @EventTypeID
	IF @@ROWCOUNT > 0
		RETURN 0
	
	INSERT	EventExclusion
		(ELServerID, EventTypeID)
		VALUES(@ELServerID, @EventTypeID)
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.EventTypeListGet
AS
SELECT	EventTypeID
	,EventTypeName
FROM	EventType
ORDER BY
	EventTypeName

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.LogEntriesClear
(
	@TimeGenerated		DATETIME
	,@RowsDeleted		INT OUTPUT
)
AS
	DELETE	LogEntry
	WHERE	LEID IN (SELECT TOP 1000 LEID FROM LogEntry WHERE TimeGenerated < @TimeGenerated)
	SET @RowsDeleted = @@rowcount
	
	IF @RowsDeleted < 1000	BEGIN
		DELETE	ELSource
		WHERE	ELSourceID NOT IN (SELECT DISTINCT ELSourceID FROM LogEntry)
	
		DELETE	ELUser
		WHERE	ELUserID NOT IN (SELECT DISTINCT ELUserID FROM LogEntry)
	
		DELETE	EventCategory
		WHERE	EventCategoryID NOT IN (SELECT DISTINCT EventCategoryID FROM LogEntry)
	END
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.LogEntriesClearAll
AS
	DELETE	LogEntry
	DELETE	ELServerLogType
	DELETE	LogType
	DELETE	EventCategory
	DELETE	ELUser
	DELETE	ELSource

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.LogEntryExclusionCheck
(
		@ELServerID	INT
		,@EventTypeID	INT
)
AS
	declare @nTemp	INT
	SELECT	@nTemp = ELServerID
	FROM	EventExclusion
	WHERE	ELServerID = @ELServerID
		AND EventTypeID = @EventTypeID
	IF @@rowcount > 0
		SELECT InExclusionList = 1
	ELSE
		SELECT InExclusionList = 0

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.LogEntryInsert
(
	@ELServerID		INT
	,@LogTypeName		VARCHAR(127)
	,@RecordNumber		INT
	,@TimeGenerated		DATETIME
	,@TimeWritten		DATETIME
	,@EventID		INT
	,@EventTypeID		INT
	,@EventCategoryID	INT
	,@EventCategoryName	VARCHAR(127)
	,@UserName		VARCHAR(255)
	,@SourceName		VARCHAR(127)
	,@FullMessage		VARCHAR(1024)
)
AS
DECLARE	@LogTypeID		INT
DECLARE	@ELUserID		INT
DECLARE @ELSourceID		INT
-- *** find out log type id
SELECT	@LogTypeID = LogTypeID
FROM	LogType
WHERE	LogTypeName = @LogTypeName
-- have to insert a new type
IF @@ROWCOUNT = 0
BEGIN
	INSERT	LogType (LogTypeName) VALUES(@LogTypeName)
	SET	@LogTypeID = @@IDENTITY	
END
-- *** END find out log type id
-- *** find out ELServerID and LogTypeID
SELECT	@ELServerID = ELServerID
	,@LogTypeID = LogTypeID
FROM	ELServerLogType
WHERE	ELServerID = @ELServerID AND LogTypeID = @LogTypeID
-- have to insert a new ELServerLogType
IF @@ROWCOUNT = 0
BEGIN
	INSERT	ELServerLogType (ELServerID, LogTypeID) VALUES(@ELServerID, @LogTypeID)
END
-- *** END find out ELServerLogTypeID
-- *** find out event category type id
IF @EventCategoryName = ''
	SET @EventCategoryName = 'None'
SELECT	@EventCategoryID = EventCategoryID
FROM	EventCategory
WHERE	EventCategoryID = @EventCategoryID
-- check the exclusion list.  If the combination is in the list
-- do not insert it
SELECT	ELServerID
FROM	EventExclusion
WHERE	ELServerID = @ElServerID
	AND EventTypeID = @EventTypeID
IF @@ROWCOUNT > 0
	RETURN 1
-- have to insert a new EventCategory 
IF @@ROWCOUNT = 0
BEGIN
	INSERT	EventCategory (EventCategoryID, EventCategoryName) VALUES(@EventCategoryID, @EventCategoryName)
END
-- *** END find out event category type id
-- *** find out user id
IF @UserName = ''
	SET @UserName = 'Unknown'
SELECT	@ELUserID = ELUserID
FROM	ELUser
WHERE	ELUserName = @UserName
-- have to insert a new ELUser 
IF @@ROWCOUNT = 0
BEGIN
	INSERT	ELUser (ELUserName) VALUES(@UserName)
	SET	@ELUserID = @@IDENTITY	
END
-- *** END find out user id
-- *** find out source id
SELECT	@ELSourceID = ELSourceID
FROM	ELSource
WHERE	ELSourceName = @SourceName
-- have to insert a new ELSource 
IF @@ROWCOUNT = 0
BEGIN
	INSERT	ELSource (ELSourceName) VALUES(@SourceName)
	SET	@ELSourceID = @@IDENTITY	
END
-- *** END find out source id
/*
SELECT	LEID
FROM	LogEntry
WHERE	RecordNumber = @RecordNumber
	AND ELServerID = @ELServerID
	AND LogTypeID = @LogTypeID
IF @@ROWCOUNT > 0
	-- this entry has been stored before
	RETURN(1)
*/
-- add the log entry
INSERT	LogEntry
	(
	ELServerID
	,LogTypeID
	,RecordNumber
	,TimeGenerated
	,TimeWritten
	,EventID
	,EventTypeID
	,EventCategoryID
	,ELUserID
	,ELSourceID
	,FullMessage
	)
values
	(
	@ELServerID
	,@LogTypeID
	,@RecordNumber
	,@TimeGenerated
	,@TimeWritten
	,@EventID
	,@EventTypeID
	,@EventCategoryID
	,@ELUserID
	,@ELSourceID
	,@FullMessage
	)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.LogEntryPageDetailsGet
(
	@ids	VARCHAR(4000)
)
AS
DECLARE @sql	VARCHAR(5000)
SET @sql =  
'select	le.LEID
	,s.ELServerName
	,lt.LogTypeName
	,le.RecordNumber
	,le.TimeGenerated
	,le.EventID
	,et.EventTypeCode
	,et.EventTypeName
	,ec.EventCategoryID
	,ec.EventCategoryName
	,elu.ELUserName
	,els.ELSourceName
	,le.FullMessage
	,le.CreatedAt
from	LogEntry le
	,ELServer s
	,LogType lt
	,EventType et
	,EventCategory ec
	,ELUser elu
	,ELSource els
WHERE	le.LEID IN(' + @ids + ')' +
	'AND le.ELServerID = s.ELServerID
	AND le.LogTypeID = lt.LogTypeID
	AND le.EventTypeID = et.EventTypeID
	AND le.EventCategoryID = ec.EventCategoryID
	AND le.ELUserID = elu.ELUserID
	AND le.ELSourceID = els.ELSourceID
ORDER BY le.LEID'
EXECUTE(@sql)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.LogEntryTop1000Delete
(
	@ELServerID		INT
	,@RowsDeleted		INT OUTPUT
)
AS
	DELETE	LogEntry
	WHERE	LEID IN (SELECT TOP 1000 LEID FROM LogEntry WHERE ELServerID = @ELServerID)
	SET @RowsDeleted = @@rowcount
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.MenuServerListGet
AS
SELECT	s.ELServerID
	,s.ELServerName
	,lt.LogTypeID
	,lt.LogTypeName
FROM	ELServer s
	INNER JOIN ELServerLogType slt ON s.ELServerID = slt.ELServerID
	INNER JOIN LogType lt ON slt.LogTypeID = lt.LogTypeID
WHERE	s.Status = 1
ORDER BY
	s.ELServerName
	,lt.LogTypeName

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.SavedReportDelete
(
	@SavedReportHdrID		INT
)
AS
	DELETE	SavedReportItem
	WHERE	SavedReportHdrID = @SavedReportHdrID	
	DELETE	SavedReportHdr
	WHERE	SavedReportHdrID = @SavedReportHdrID
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.SavedReportGet
(
	@SavedReportHdrID	INT
)
AS
	SELECT	srh.SavedReportHdrID
		,srh.SavedReportDescription
		,sri.SavedReportMetaData
	FROM	SavedReportHdr srh
		,SavedReportItem sri
	WHERE	srh.SavedReportHdrID = @SavedReportHdrID
		AND srh.SavedReportHdrID = sri.SavedReportHdrID
	ORDER BY
		sri.SavedReportItemID
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.SavedReportHdrMake
(
	@SavedReportHdrID		INT OUTPUT
	,@AppUserID			INT
	,@SavedReportDescription	VARCHAR(255)
)
AS
	-- check if the report description exists already
	SELECT	SavedReportHdrID
	FROM	SavedReportHdr
	WHERE	AppUserID = @AppUserID
		AND SavedReportDescription = @SavedReportDescription
	IF @@ROWCOUNT > 0
		RETURN 204	-- record exists
	
	INSERT	SavedReportHdr
		(AppUserID, SavedReportDescription)
		VALUES(@AppUserID, @SavedReportDescription)
	SET @SavedReportHdrID = @@IDENTITY
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.SavedReportListGet
(
	@AppUserID	INT
)
AS
	SELECT	SavedReportHdrID
		,SavedReportDescription
	FROM	SavedReportHdr
	WHERE	AppUserID = @AppUserID
	ORDER By SavedReportDescription
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.SavedReportMetaDataAdd
(
	@SavedReportHdrID		INT
	,@SavedReportItemID		INT
	,@SavedReportMetaData		VARCHAR(1023)
)
AS
	-- check if the header exists
	SELECT	SavedReportHdrID
	FROM	SavedReportHdr
	WHERE	SavedReportHdrID = @SavedReportHdrID
	IF @@ROWCOUNT = 0
		RETURN 206	-- no header
	
	INSERT	SavedReportItem
		(SavedReportHdrID, SavedReportItemID, SavedReportMetaData)
		VALUES(@SavedReportHdrID, @SavedReportItemID, @SavedReportMetaData)
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.ServerAdd
(
	@ELServerID		INT OUTPUT
	,@ELServerName		VARCHAR(50)
	,@ELServerDescription	VARCHAR(255)
)
AS
	-- check if the user is in the table already
	SELECT	ELServerID
	FROM	ELServer
	WHERE	ELServerID = @ELServerID
	IF @@ROWCOUNT > 0
		RETURN 204	-- record exists
	
	INSERT	ELServer
		(ELServerName, ELServerDescription)
		VALUES(@ELServerName, @ELServerDescription)
	SET @ELServerID = @@IDENTITY
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.ServerDelete
(
	@ELServerID		INT
)
AS
	
-- note: before deleting ELServer entry
-- call LogEntryTop1000Delete enough times to delete events associated with the server
-- can't delete all at once -- problems with timeouts
--	DELETE	LogEntry
--	WHERE	ELServerID = @ELServerID	
	DELETE	ELServerLogType
	WHERE	ELServerID = @ELServerID
	DELETE	EventExclusion
	WHERE	ELServerID = @ELServerID
	DELETE	ELServer
	WHERE	ELServerID = @ELServerID
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.ServerDisable
(
	@ELServerID		INT
)
AS
	UPDATE	ELServer
	SET	Status = 0
	WHERE	ELServerID = @ELServerID
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.ServerListGet
AS
	SELECT	ELServerID
		,ELServerName
		,ELServerDescription = ISNULL(ELServerDescription, '&nbsp')
	FROM	ELServer
	WHERE	Status = 1
	ORDER By ELServerName
	RETURN (0)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.SourceNameListGet
AS
SELECT	ELSourceID
	,ELSourceName
FROM	ELSource
ORDER BY
	ELSourceName

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROC dbo.VersionInfoGet
	(
		@VersionInfoDesc	VARCHAR(255) OUTPUT
	)
AS
SELECT	@VersionInfoDesc = VersionInfoDesc
FROM	VersionInfo

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

