/*
Populate the EventType table
*/

USE GsEventLogGathererDB
GO

-- clear all rows
DELETE EventType

INSERT	EventType
	(EventTypeID, EventTypeCode, EventTypeName, EventTypeDesc)
	VALUES(0, 'EVENTLOG_UNKNOWN', 'Unknown&nbsp;Type', 'If the event type is not Error or Warning or Information or Success Audit or Failure Audit then default to Unknown.')
INSERT	EventType
	(EventTypeID, EventTypeCode, EventTypeName, EventTypeDesc)
	VALUES(1, 'EVENTLOG_ERROR_TYPE', 'Error', 'Error events indicate significant problems that the user should know about. Error events usually indicate a loss of functionality or data. For example, if a service cannot be loaded as the system boots, it can log an error event.')
INSERT	EventType
	(EventTypeID, EventTypeCode, EventTypeName, EventTypeDesc)
	VALUES(2, 'EVENTLOG_WARNING_TYPE', 'Warning', 'Warning events indicate problems that are not immediately significant, but that may indicate conditions that could cause future problems. Resource consumption is a good candidate for a warning event. For example, an application can log a warning event if disk space is low. If an application can recover from an event without loss of functionality or data, it can generally classify the event as a warning event.')
INSERT	EventType
	(EventTypeID, EventTypeCode, EventTypeName, EventTypeDesc)
	VALUES(4, 'EVENTLOG_INFORMATION_TYPE', 'Information', 'Information events indicate infrequent but significant successful operations. For example, when Microsoft SQL Server successfully loads, it may be appropriate to log an information event stating that "SQL Server has started." Note that while this is appropriate behavior for major server services, it is generally inappropriate for a desktop application (Microsoft Excel, for example) to log an event each time it starts.')
INSERT	EventType
	(EventTypeID, EventTypeCode, EventTypeName, EventTypeDesc)
	VALUES(8, 'EVENTLOG_AUDIT_SUCCESS', 'Success&nbsp;Audit', 'Success audit events are security events that occur when an audited access attempt is successful. For example, a successful logon attempt is a success audit event.')
INSERT	EventType
	(EventTypeID, EventTypeCode, EventTypeName, EventTypeDesc)
	VALUES(16, 'EVENTLOG_AUDIT_FAILURE', 'Failure&nbsp;Audit', 'Failure audit events are security events that occur when an audited access attempt fails. For example, a failed attempt to open a file is a failure audit event.')
GO

-- insert default ELUser
DELETE	ELUSer
SET IDENTITY_INSERT ELUser ON 
GO
INSERT	ELUser
	(ELUserID, ELUserName)
	VALUES(0, 'None')
SET IDENTITY_INSERT ELUser OFF
GO


/*
Populate Role and Page tables
*/

DELETE	AppUserRole
DELETE	AppUser
DELETE	AppRole

/*
Populate user admin tables
*/

-- sp_help Role
INSERT AppRole
	(AppRoleID, AppRoleName, AppRoleDescription)
	VALUES(1, 'Administrator', 'Member of the Administrator role has permissions to administer and use the reports tool.')
INSERT AppRole
	(AppRoleID, AppRoleName, AppRoleDescription)
	VALUES(2, 'User', 'Member of the User role has permissions to to view the log reports.')


-- sp_help AppUser
SET IDENTITY_INSERT AppUser ON 
GO
INSERT AppUser
	(AppUserID, AppUserName, AppUserPassword, AppUserFirstName, AppUserLastName, AppUserDescription)
	VALUES(10000, 'Administrator', 'administrator', 'Administrator', 'Administrator', 'Built-in administrator account.')
SET IDENTITY_INSERT AppUser OFF
GO

-- sp_help AppUserRole
INSERT AppUserRole
	(AppUserID, AppRoleID)
	VALUES(10000, 1)
GO

INSERT VersionInfo
	(VersionInfoDesc)
	VALUES('GSEventLogGatherer Version 1.50  - Beta,
Copyright  2002-2003 Gravity Square, Inc. - http://www.gravitysquare.com
Developed by Alpentia Software, Inc. - http://www.alpentia.com')
GO	


