/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <stdio.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include "mc4020.h"

char *dev = "/dev/mc4020_0";

int main (int argc, char **argv)
{
  int			fd;
  int			i;
  struct mc4020_caldata	d;
  

  fd = open (dev, O_RDONLY);
  if (fd < 0){
    perror (dev);
    return 1;
  }


  if (ioctl (fd, GIOCGETCALDATA, &d) < 0){
    perror ("ioctl");
    return 1;
  }

  printf ("cal_4_375:    %g\n", d.cal_4_375);
  printf ("cal_0_625:    %g\n", d.cal_0_625);
  for (i = 0; i < 16; i++)
    printf ("cal_data[%2d]: %3d\n", i, d.cal_data[i]);

  return 0;
}
