/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.datetime;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.FloatTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.PrologStream;
import gnu.prolog.vm.TermConstants;
import gnu.prolog.vm.buildins.datetime.DateTimePrologCode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Predicate_format_time
extends DateTimePrologCode {
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        OutputFormat outFormat = OutputFormat.OF_STREAM;
        PrologStream outstream = null;
        Term outterm = null;
        Term outtermTail = null;
        if (args[0] instanceof JavaObjectTerm) {
            JavaObjectTerm jt = (JavaObjectTerm)args[0];
            if (!(jt.value instanceof PrologStream)) {
                PrologException.domainError(TermConstants.streamAtom, args[0]);
            }
        } else if (args[0] instanceof AtomTerm) {
            outstream = interpreter.getEnvironment().resolveStream(args[0]);
            if (outstream == null) {
                PrologException.domainError(TermConstants.streamAtom, args[0]);
            }
        } else if (args[0] instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)args[0];
            if (ct.tag.functor == TermConstants.atomAtom) {
                if (ct.tag.arity != 1) {
                    PrologException.typeError(TermConstants.outputAtom, ct);
                }
                outterm = ct.args[0];
                outFormat = OutputFormat.OF_ATOM;
            } else if (ct.tag.functor == TermConstants.codesAtom) {
                if (ct.tag.arity > 2) {
                    PrologException.typeError(TermConstants.outputAtom, ct);
                }
                outterm = ct.args[0];
                if (ct.args.length > 1) {
                    outtermTail = ct.args[1];
                }
                outFormat = OutputFormat.OF_CODES;
            } else if (ct.tag.functor == TermConstants.charsAtom) {
                if (ct.tag.arity > 2) {
                    PrologException.typeError(TermConstants.outputAtom, ct);
                }
                outterm = ct.args[0];
                if (ct.args.length > 1) {
                    outtermTail = ct.args[1];
                }
                outFormat = OutputFormat.OF_CHARS;
            } else {
                PrologException.typeError(AtomTerm.get("atom_codes_chars"), args[0]);
            }
        } else {
            PrologException.typeError(TermConstants.outputAtom, args[0]);
        }
        if (!(args[1] instanceof AtomTerm)) {
            PrologException.typeError(TermConstants.atomAtom, args[1]);
        }
        String format = ((AtomTerm)args[1]).value;
        Date date = args[2] instanceof FloatTerm ? new Date(Math.round(((FloatTerm)args[2]).value * 1000.0)) : Predicate_format_time.getDate(args[2]);
        Locale locale = Locale.getDefault();
        if (args.length > 3) {
            if (args[3] instanceof AtomTerm) {
                String loc = ((AtomTerm)args[3]).value;
                int idx = loc.indexOf(95);
                locale = idx > -1 ? new Locale(loc.substring(0, idx), loc.substring(idx + 1)) : new Locale(loc);
            } else {
                PrologException.typeError(TermConstants.atomAtom, args[3]);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
        String result = sdf.format(date);
        if (outstream != null) {
            outstream.writeTerm(args[0], interpreter, null, AtomTerm.get(result));
            return 1;
        }
        Term res = TermConstants.emptyListAtom;
        if (outtermTail != null) {
            res = outtermTail;
        }
        switch (outFormat) {
            case OF_ATOM: {
                res = AtomTerm.get(result);
                break;
            }
            case OF_CHARS: {
                int i = result.length() - 1;
                while (i >= 0) {
                    res = CompoundTerm.getList(AtomTerm.get(result.charAt(i)), res);
                    --i;
                }
                break;
            }
            case OF_CODES: {
                int i = result.length() - 1;
                while (i >= 0) {
                    res = CompoundTerm.getList(IntegerTerm.get(result.charAt(i)), res);
                    --i;
                }
                break;
            }
            default: {
                PrologException.systemError();
            }
        }
        return interpreter.unify(outterm, res);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OutputFormat {
        OF_STREAM,
        OF_ATOM,
        OF_CHARS,
        OF_CODES;

    }
}

