/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.io;

import gnu.prolog.io.Operator;
import gnu.prolog.io.OperatorSet;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.util.HashSet;

public class Predicate_op
extends ExecuteOnlyCode {
    static final AtomTerm commaAtom = AtomTerm.get(",");

    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        Term tpriority = args[0];
        Term topspec = args[1];
        Term tops = args[2];
        int priority = 0;
        int opspec = -1;
        HashSet<AtomTerm> ops = new HashSet<AtomTerm>();
        OperatorSet opSet = interpreter.getEnvironment().getOperatorSet();
        if (tpriority instanceof VariableTerm) {
            PrologException.instantiationError();
        }
        if (!(tpriority instanceof IntegerTerm)) {
            PrologException.typeError(TermConstants.integerAtom, tpriority);
        }
        if ((priority = ((IntegerTerm)tpriority).value) < 0 || 1200 < priority) {
            PrologException.domainError(TermConstants.operatorPriorityAtom, tpriority);
        }
        if (topspec instanceof VariableTerm) {
            PrologException.instantiationError();
        }
        if (!(topspec instanceof AtomTerm)) {
            PrologException.typeError(TermConstants.atomAtom, topspec);
        }
        if (topspec == TermConstants.xfxAtom) {
            opspec = 2;
        } else if (topspec == TermConstants.xfyAtom) {
            opspec = 3;
        } else if (topspec == TermConstants.yfxAtom) {
            opspec = 4;
        } else if (topspec == TermConstants.fxAtom) {
            opspec = 0;
        } else if (topspec == TermConstants.fyAtom) {
            opspec = 1;
        } else if (topspec == TermConstants.xfAtom) {
            opspec = 5;
        } else if (topspec == TermConstants.yfAtom) {
            opspec = 6;
        } else {
            PrologException.domainError(TermConstants.operatorSpecifierAtom, topspec);
        }
        if (tops != TermConstants.emptyListAtom) {
            if (tops instanceof AtomTerm) {
                Predicate_op.validateOp(priority, opspec, (AtomTerm)tops, opSet);
                ops.add((AtomTerm)tops);
            } else if (tops instanceof CompoundTerm) {
                Term cur = tops;
                while (cur != TermConstants.emptyListAtom) {
                    if (cur instanceof VariableTerm) {
                        PrologException.instantiationError();
                    }
                    if (!(cur instanceof CompoundTerm)) {
                        PrologException.typeError(TermConstants.listAtom, tops);
                    }
                    CompoundTerm ct = (CompoundTerm)cur;
                    if (ct.tag != TermConstants.listTag) {
                        PrologException.typeError(TermConstants.listAtom, tops);
                    }
                    Term head = ct.args[0].dereference();
                    cur = ct.args[1].dereference();
                    if (head instanceof VariableTerm) {
                        PrologException.instantiationError();
                    }
                    if (!(head instanceof AtomTerm)) {
                        PrologException.typeError(TermConstants.atomAtom, head);
                    }
                    Predicate_op.validateOp(priority, opspec, (AtomTerm)head, opSet);
                    ops.add((AtomTerm)head);
                }
            } else {
                PrologException.typeError(TermConstants.listAtom, tops);
            }
        }
        if (priority == 0) {
            for (AtomTerm op : ops) {
                opSet.remove(opspec, op.value);
            }
        } else {
            for (AtomTerm op : ops) {
                opSet.add(priority, opspec, op.value);
            }
        }
        return 1;
    }

    private static void validateOp(int priority, int specifier, AtomTerm opAtom, OperatorSet opSet) throws PrologException {
        if (opAtom == commaAtom) {
            PrologException.permissionError(TermConstants.modifyAtom, TermConstants.operatorAtom, opAtom);
        }
        switch (specifier) {
            case 0: 
            case 1: {
                break;
            }
            case 5: 
            case 6: {
                Operator op = opSet.lookupXf(opAtom.value);
                if (op.specifier == 6 || specifier == 5) break;
                PrologException.permissionError(TermConstants.createAtom, TermConstants.operatorAtom, opAtom);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                Operator op = opSet.lookupXf(opAtom.value);
                if (op.specifier != 6 && specifier != 5) break;
                PrologException.permissionError(TermConstants.createAtom, TermConstants.operatorAtom, opAtom);
                break;
            }
        }
    }
}

