unit    class Async::Command:ver<0.0.2>:auth<Mark Devine (mark@markdevine.com)>;

use     Async::Command::Result;

has Str @.command is required;
has Str $.unique-id;
has Int $.timeout;

method run {
    my $proc = Proc::Async.new(@!command);
    my $c-stdout = Channel.new || die;
    my $c-stderr = Channel.new || die;
    my $o-tap = $proc.stdout.act(-> $o { if $c-stdout.closed { note 'O: ' ~ $o } else { $c-stdout.send($o) } },
                                         quit => { say 'caught exception ' ~ .^name });
    my $e-tap = $proc.stderr.act(-> $e { if $c-stderr.closed { note 'E: ' ~ $e } else { $c-stderr.send($e) } },
                                         quit => { say 'caught exception ' ~ .^name });
    my $promise = $proc.start;
    my $waitfor = $promise;
    $waitfor = Promise.anyof(Promise.in($!timeout), $promise) if $!timeout;
    $ = await $waitfor;
    $o-tap.close;
    $e-tap.close;
    $c-stdout.close;
    $c-stderr.close;
    my $stdout-results = $c-stdout.list.join;
    my $stderr-results = $c-stderr.list.join;
    if !$!timeout || $promise.status ~~ Kept {
        return Async::Command::Result.new(
            :@!command,
            :exitcode($promise.result.exitcode),
            :$stdout-results,
            :$stderr-results,
            :$!unique-id,
        );
    }
    else {
        $stderr-results = "[timed out]\n" ~ $stderr-results;
        $proc.kill;
        if $promise.status ~~ Planned {
            sleep 1;
            $proc.kill(15);
        }
        if $promise.status ~~ Planned {
            sleep 1;
            $proc.kill(9);
        }
        $ = await $promise;
        return Async::Command::Result.new(
            :@!command,
            :$stdout-results,
            :$stderr-results,
            :timed-out,
            :$!unique-id,
        );
    }
}

=finish
