########################################################################
# test using module with no args (all defaults) for perl version values.
########################################################################
use 5.008;
use strict;
use version;

use Test::More;
use Test::Deep;

use File::Basename  qw( basename    );
use FindBin         qw( $Bin        );

use lib( "$Bin/../../lib", "$Bin/../lib" );
use Test::KwikHaks;

my $madness = 'Module::FromPerlVer';
my $v_dir   = 'version';

*output     = Test::KwikHaks->can( 'output' );

output();
output( "Test sandbox: '$v_dir'" );

my ( $base, $perl_v )  
= eval
{
    Test::KwikHaks::perl_v_from_basename()
}
or BAIL_OUT "Missing Perl Version: $@";

local $ENV{ PERL_VERSION } = $perl_v;

eval
{
    use_ok $madness;

    1
}
or BAIL_OUT "Use failed: $@";

for my $prefix ( $madness->source_prefix )
{
    is $prefix, $v_dir, "Source prefix: '$prefix' ($v_dir)";
}

for my $found ( scalar $madness->source_files )
{
    @$found
    ? pass 'Found source files in version directory'
    : fail 'Missing source files for cleanup'
    ;

    note "Source files:\n", explain $found;

    ok -e , "Found: '$_'"
    for @$found;
}

eval
{
    $madness->cleanup;

    pass "Survived cleanup.";
}
or 
fail "Failed cleanup: $@";

done_testing;
__END__
