# use "*_t" for basename of this file.
# symlink to *-<perl version string to test>.t.
# e.g.,
#   "20-foo-v5.5.3.t"
#   "20-bar-5.005_003"
#   "20-bar-v5.005003"
# will test varieties of the same perl version string.

use 5.006;
use version;

use Test::More;
use Test::Deep;

use File::Basename  qw( basename    );
use FindBin         qw( $Bin        );

use lib "$Bin/../lib";

my $madness = 'Module::FromPerlVer';
my $sandbox = "$Bin/sandbox";

note "Test sandbox: '$sandbox'";

SKIP:
{
    my $base    = basename $0, '.t';

    my ( $perl_v )
    =  $base =~ m{ .* defaults \W+ (.+) }x
    or 
    skip "Botched test: no perl version in '$base'.", 1;

    note "Testing perl version: '$perl_v'.";

    version->parse( $perl_v )->numify
    or skip "Botched test: non-parsable '$perl_v' ($base).";

    chomp( my $git = qx( git --version ) );

    note "git version: '$git'";

    like $git, qr{^ git }x, "Git version: '$git'"
    or skip 'Failed running git.', 1;

    -d $sandbox
    or skip "Non-existant: '$sandbox'", 1;

    chdir $sandbox
    or skip "Faild chdir '$sandbox', $!\n", 1;
    
    # clean any previous test files.
    # this leaves the .git.tar, .git.

    system '/bin/rm -rf *';

    local $ENV{ PERL_VERSION } = $perl_v;

    use_ok $madness => qw( use_git 1 )
    or BAIL_OUT "$madness is not usable.";

    my $prefix  = $madness->source_prefix;

    is $prefix, 'perl/', "Source prefix: '$found' (perl/)";

    for my $found ( $madness->source_files )
    {
        note "Source files:\n", explain $found;

        fail "Extraneous souce files: $found";
    }

    eval
    {
$DB::single = 1;

        chomp( my $found = ( qx{ git branch } )[0] );

        ok 0 < index( $found, $prefix ),
        "Found: '$prefix' in '$found'"
        or do
        {
            die "No prefix: '$prefix' in '$found'.\n";
        };

        my $v_rx    = qr{ $prefix ([\d._]+) \b }x;

        if
        (
            my ( $tag_v ) = $found =~ $v_rx
        )
        {
            pass "Tag version: '$tag_v'";

            my $i   = version->parse( $tag_v  )->numify;
            my $j   = version->parse( $perl_v )->numify;

            ok $i <= $j, "Tag ($i) <= Perl ($j)";
        }
        else
        {
            fail "No version: '$v_rx'";
            diag "Git status: '$found'";
        }
        

        1
    }
    or fail "Unable to determine branch: $@";
}

done_testing;
__END__
