#!/usr/bin/env perl6

use JSON::Fast;
use Getopt::Advance;
use File::Directory::Tree;

my $json = Q:to/OPTION/;
{
    "option": [
        {
            "short": "ver",
            "type" : "s",
            "annotation": "Using ver instead of version info in META6.json"
        },
        {
            "short": "out",
            "type" : "s",
            "value": ".",
            "annotation": "Set the pack output directory"
        },
        {
            "short": "md",
            "type" : "b",
            "annotation": "Convert the asciidoc(README) to markdown"
        }
    ]
}
OPTION

sub load-from-json($os, $json) {
    my @json := (from-json $json)<option>;

    for @json -> $info {
        my $optstr = "{$info<short>}|={$info<type>}";
        my $annotation = $info<annotation>;

        $os.push(my $opt = $os.create( $optstr, :$annotation));
        if $info<value>:exists {
            $opt.set-default-value($info<value>);
            $opt.reset-value;
        }
    }
    $os;
}

Getopt::Advance::Utils::Debug::setLevel(0);

my OptionSet $os .= new;

$os.append(
    "h|help=b"      => 'Print the help message',
    "v|version=b"   => 'Print the version info',
    "d|debug=b"     => 'Print debug message',
);

my $os1 = $os.clone();
my $os2 = $os.clone();

$os1.insert-cmd("abc", "Using abc feature!!");
$os.insert-pos(
    "module",
    "The directory of the module",
    sub ($os, $dir) {
        return False if $dir.value.IO !~~ :d;
        True;
    },
    :last,
);
$os.insert-pos(
    "add",
    "Using add command",
    sub ($os, $dir) {
        return False if $dir.value.IO !~~ :d;
        True;
    },
    :front,
);
$os.insert-pos(
    "foo",
    "Using foo as 1 position argument",
    1,
    sub ($os, $dir) {
        return False if $dir.value.IO !~~ :d;
        True;
    },
);
$os.insert-cmd(
    "remove",
    "Using remove command",
);
&getopt(
    :autohv,
    &load-from-json($os, $json),
    $os1,
    $os2,
    version => Q:to/VERSION/,
    make-cpan-pack 0.1.
    Make cpan package according the module META6.json.
    Create by loren.
    VERSION
);
