/*
 * yow.c: yow?!
 *
 * Copyright(c) 2000  - All Rights Reserved
 *
 * See the COPYRIGHT file.
 */

#ifndef lint
static char rcsid[] = "@(#)$Id: yow.c,v 1.1 2000/09/03 19:08:58 kalt Exp $";
#endif

#include "os.h"

#include "struct.h"
#include "window.h"
#include "utils.h"

extern  int     cmd_msgnotice(char *, char *);
extern	int	cmd_option(char *);

void
yow_init()
{
  if (access(YOW_PATH, X_OK) == 0)
      vsic_slog(LOG_DEBUG, "yow! %s", YOW_PATH);
  else
    {
      char noyow[15];

      vsic_slog(LOG_DEBUG, "YOW_PATH=%s", YOW_PATH);
      if (strcmp(YOW_PATH, ""))
	  sic_slog(LOG_CLIENT,
		   "yow is now missing, you may want to recompile sic");

      strcpy(noyow, "s.t.s.12 on");
      cmd_option(noyow);
    }
}

char *
yow()
{
  FILE *yfd;

  yfd = popen(YOW_PATH, "r");
  if (yfd)
    {
#define YB_LEN (80*4)
      static char yb[YB_LEN], line[80];

      yb[0] = '\0';
      while (!feof(yfd))
	{
	  line[0] = '\0';
	  fgets(line, 80, yfd);

	  if (strlen(yb) + strlen(line) >= YB_LEN)
	    {
	      sic_slog(LOG_CLIENT, "--- yow failed.");
	      vsic_slog(LOG_DEBUG, "yb=%s", yb);
	      vsic_slog(LOG_DEBUG, "line=%s", line);
	      return NULL;
	    }

	  if (*line)
	    {
	      vsic_slog(LOG_DEBUG, "line=%s", line);
	      strcat(yb, line);
	      yb[strlen(yb)-1] = '\0';
	    }
	}
      pclose(yfd);
      return yb;
    }
  else
    {
      vsic_slog(LOG_CLIENT, "--- popen() failed: %s", strerror(errno));
      return NULL;
    }
}

void
yow_back(channel, msg)
char *channel, *msg;
{
  char *c, *str = msg;

  while (c = strcasestr(str, "yow"))
    {
      if (((c == str) || !isalpha(*(c-1))) && !isalpha(*(c+3)))
	  break;
      str = c+1;
    }
  if (c && (str = yow()))
    {
      static	time_t	last_t = 0;
      static	char	last_cnt;
      
      if ((time(NULL) - last_t) < 5)
	{
	  if (++last_cnt >= 4)
	    return;
	}
      else
	{
	  last_t = time(NULL);
	  last_cnt = 1;
	}

      c = malloc(strlen(channel) + strlen(str) + 2);
      sprintf(c, "%s %s", channel, str);
      cmd_msgnotice("PRIVMSG", c);
      free(c);
    }
}
