# unix.tcl --
# X11 platform specific settings
# Note that there is also some platform code in main.tcl to bootstap things

# Pick a large display size
option add *Text.height 		40 	startup
option add *Text.width 			80 	startup
option add *Scrollbar.width		11	startup

# The name of the per-user preferences file
proc Platform_File {key} {
    switch $key {
	prefs {
	    if [file exists [glob -nocomplain ~]/.webedit] {
		return [glob -nocomplain ~]/.webedit
	    } else {
		return [glob -nocomplain ~]/.webtk
	    }
	}
	macros {
	    return [glob -nocomplain ~]/.webtkmacros
	}
	tcl {
	    return [glob -nocomplain ~]/.webtk.tcl
	}
	def {
	    return [glob -nocomplain ~]/.webtkdefaults
	}
	log {
	    return /tmp/webtk.log.[pid]
	}
	tmp {
	    return [glob -nocomplain ~]/.webtk_tmp
	}
    }
}

# Wait for a dialog before doing a grab
proc Platform_WaitVisibility {win} {
    catch {tkwait visibility $win}
}

proc Platform_TempFile {url} {
    regsub -all {/} $url _ file
    return /tmp/$file.[pid]
}
