/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import tcl.lang.Channel;
import tcl.lang.ConsoleEvent;
import tcl.lang.Interp;
import tcl.lang.StdChannel;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

class ConsoleThread
extends Thread {
    private static final boolean debug = false;
    private static boolean sysInAvailableWorks = false;
    Interp interp;
    Vector historyObjs;
    StringBuffer sbuf;
    private Channel in;
    private Channel out;
    private Channel err;

    public synchronized void run() {
        this.put(this.out, "% ");
        while (true) {
            TclObject prompt;
            this.getLine();
            if (Interp.commandComplete(this.sbuf.toString())) {
                ConsoleEvent evt = new ConsoleEvent(this.interp, this.sbuf.toString());
                this.interp.getNotifier().queueEvent(evt, 0);
                evt.sync();
                if (evt.evalResult != null) {
                    String s = evt.evalResult.toString();
                    if (s.length() > 0) {
                        this.putLine(this.out, s);
                    }
                    int limit = 0;
                    try {
                        TclObject histLimit = this.interp.getVar("historyLimit", 1);
                        if (histLimit != null) {
                            limit = TclInteger.get((Interp)this.interp, (TclObject)histLimit);
                        }
                    }
                    catch (TclException histLimit) {
                        // empty catch block
                    }
                    if (limit > 0) {
                        this.historyObjs.addElement(evt.evalResult);
                    } else {
                        evt.evalResult.release();
                    }
                    if (this.historyObjs.size() > limit && this.historyObjs.size() > 0) {
                        TclObject cobj = (TclObject)this.historyObjs.elementAt(0);
                        this.historyObjs.removeElementAt(0);
                        cobj.release();
                    }
                } else {
                    TclException e = evt.evalException;
                    int code = e.getCompletionCode();
                    if (code != 2 || (code = this.interp.updateReturnInfo()) != 0) {
                        switch (code) {
                            case 1: {
                                this.putLine(this.err, this.interp.getResult().toString());
                                break;
                            }
                            case 3: {
                                this.putLine(this.err, "invoked \"break\" outside of a loop");
                                break;
                            }
                            case 4: {
                                this.putLine(this.err, "invoked \"continue\" outside of a loop");
                                break;
                            }
                            default: {
                                this.putLine(this.err, "command returned bad code: " + code);
                            }
                        }
                    }
                }
                this.sbuf.setLength(0);
                try {
                    prompt = this.interp.getVar("tcl_prompt1", 1);
                }
                catch (TclException e) {
                    prompt = null;
                }
                if (prompt != null) {
                    try {
                        this.interp.eval(prompt.toString(), 1);
                    }
                    catch (TclException e) {
                        this.put(this.out, "% ");
                    }
                    continue;
                }
                this.put(this.out, "% ");
                continue;
            }
            try {
                prompt = this.interp.getVar("tcl_prompt2", 1);
            }
            catch (TclException e) {
                prompt = null;
            }
            if (prompt != null) {
                try {
                    this.interp.eval(prompt.toString(), 1);
                }
                catch (TclException e) {
                    this.put(this.out, "> ");
                }
                continue;
            }
            this.put(this.out, "> ");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void getLine() {
        void var1_1;
        int availableBytes = -1;
        if (sysInAvailableWorks) {
            try {
                availableBytes = 0;
                while (availableBytes == 0) {
                    availableBytes = System.in.available();
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                System.exit(0);
            }
            catch (EOFException e) {
                System.exit(0);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        char c2 = ' ';
        char c = ' ';
        while (var1_1 != false) {
            try {
                int i = System.in.read();
                if (i == -1) {
                    if (this.sbuf.length() == 0) {
                        System.exit(0);
                    } else {
                        return;
                    }
                }
                c = (char)i;
                --availableBytes;
                if (c == '\r') {
                    i = System.in.read();
                    if (i == -1) {
                        if (this.sbuf.length() == 0) {
                            System.exit(0);
                        } else {
                            return;
                        }
                    }
                    if ((c2 = (char)((char)i)) == '\n') {
                        c = c2;
                    } else {
                        this.sbuf.append(c);
                        c = c2;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
            this.sbuf.append(c);
            if (c != 10) continue;
            return;
        }
    }

    private void putLine(Channel chan, String s) {
        this.put(chan, s);
        this.put(chan, "\n");
    }

    private void put(Channel chan, String s) {
        try {
            this.out.write(this.interp, s);
            this.out.flush(this.interp);
        }
        catch (Exception e) {
            throw new TclRuntimeError("unexpected Exception " + e);
        }
    }

    ConsoleThread(Interp i) {
        this.setName("ConsoleThread");
        this.interp = i;
        this.sbuf = new StringBuffer(100);
        this.historyObjs = new Vector();
        this.out = new StdChannel("stdout");
        this.err = new StdChannel("stderr");
    }

    static {
        try {
            System.in.available();
            sysInAvailableWorks = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Util.isWindows()) {
            sysInAvailableWorks = false;
        }
    }
}

