# -[Fri Oct  9 16:27:33 1992 by cxh]-
# Bring up windows for table definitions and for column definitions.

proc tableDef {table_name {w .t1}} {
  catch {destroy $w}
  toplevel $w
  wm title $w "Table Definitions"
  wm geometry $w 300x400+10+500
  wm minsize $w 200 300
  wm iconname $w "TableDef"
  frame $w.frame -borderwidth 10
  frame $w.frame.ent
  SQLselect tab_sel * from tables where table_name = '$table_name'
  
  set owner $tab_sel(1,1)
  set date_update $tab_sel(1,2)
  set progs $tab_sel(1,3)
  pack append $w.frame.ent \
    [button $w.frame.ent.b1 -text "Exit" \
     -command "destroy $w" ] {top fillx} \
    [label $w.frame.ent.l1 -relief sunken -borderwidth 1 \
     -text "Table: $table_name"] {top fillx} \
    [label $w.frame.ent.l2 -relief sunken -borderwidth 1 \
     -text "Owner: $owner"] {top fillx} \
    [label $w.frame.ent.l3 -relief sunken -borderwidth 1 \
     -text "Date of last update: $date_update"] \
    {top fillx} \
    [label $w.frame.ent.l4 -relief sunken -borderwidth 1 \
     -text "Programs: $progs"] {top fillx} 
  
  pack append $w $w.frame {top fillx}
  pack append $w.frame $w.frame.ent {top fillx}
  
  # Create the description box
  frame $w.frame.txt
  pack append $w.frame $w.frame.txt {bottom expand fill}
  
  label $w.frame.txt.l1 -relief sunken -borderwidth 1 \
    -text "Description"
  
  scrollbar $w.frame.txt.vscrollbar \
    -command "$w.frame.txt.text yview" -relief sunken
  scrollbar $w.frame.txt.hscrollbar -relief sunken -orient horizontal \
    -command "$w.frame.txt.text xview"
  
  text $w.frame.txt.text -height 20 -width 16 \
    -yscrollcommand "$w.frame.txt.vscrollbar set" 
  #		-xscrollcommand "$w.frame.txt.hscrollbar set" 
  
  pack append $w.frame.txt $w.frame.txt.l1 {top fillx} \
    $w.frame.txt.hscrollbar {top fillx} \
    $w.frame.txt.vscrollbar {left filly} \
    $w.frame.txt.text {left expand fill}
  
  $w.frame.txt.text delete 0.0 end
  $w.frame.txt.text insert 0.0 "$tab_sel(1,4)"
  
  #pack append $w.frame.txt 
  
}

proc columnDef {column_name {w .c1}} {
  catch {destroy $w}
  toplevel $w
  wm title $w "Column Definitions"
  wm geometry $w 300x400+20+550
  wm minsize $w 200 300
  wm iconname $w "ColumnDef"
  frame $w.frame -borderwidth 10
  frame $w.frame.ent
  SQLselect col_sel * from columns where col_name = '$column_name'
  
  set table_name $col_sel(1,1)
  pack append $w.frame.ent \
    [button $w.frame.ent.b1 -text "Exit" \
     -command "destroy $w" ] {top fillx} \
    [label $w.frame.ent.l1 -relief sunken -borderwidth 1 \
     -text "Column: $column_name"] {top fillx} \
    [label $w.frame.ent.l2 -relief sunken -borderwidth 1 \
     -text "Table: $table_name"] {top fillx} 
  
  pack append $w $w.frame {top fillx}
  pack append $w.frame $w.frame.ent {top fillx}
  
  # Create the description box
  frame $w.frame.txt
  pack append $w.frame $w.frame.txt {bottom expand fill}
  
  label $w.frame.txt.l1 -relief sunken -borderwidth 1 \
    -text "Description"
  
  scrollbar $w.frame.txt.vscrollbar \
    -command "$w.frame.txt.text yview" -relief sunken
  scrollbar $w.frame.txt.hscrollbar -relief sunken -orient horizontal \
    -command "$w.frame.txt.text xview"
  
  text $w.frame.txt.text -height 20 -width 16 \
    -yscrollcommand "$w.frame.txt.vscrollbar set"
  #		-xscrollcommand "$w.frame.txt.hscrollbar set" 
  
  pack append $w.frame.txt $w.frame.txt.l1 {top fillx} \
    $w.frame.txt.hscrollbar {top fillx} \
    $w.frame.txt.vscrollbar {left filly} \
    $w.frame.txt.text {left expand fill}
  
  $w.frame.txt.text delete 0 end
  $w.frame.txt.text insert 0 "$col_sel(1,2)"
  
  #pack append $w.frame.txt 
}

proc commandButton { command {w .txt1}} {
  catch {destroy $w}
  toplevel $w
  wm title $w "Output from SQL command"
  wm geometry $w 300x400+20+550
  wm minsize $w 200 300
  wm iconname $w "SQL Command"
  frame $w.frame
  frame $w.frame.canvas -borderwidth 10
  
  #	pack append $w.frame \
    #		[button $w.frame.b1 -text "Exit" \
		 #			-command "destroy $w" ] {top fillx}
  
  
  
  scrollbar $w.frame.canvas.vscrollbar \
    -command "$w.frame.canvas.text yview" -relief sunken
  scrollbar $w.frame.canvas.hscrollbar -relief sunken -orient horizontal \
    -command "$w.frame.canvas.text xview"
  
  canvas $w.frame.canvas.text -scrollregion {0 0 5000 1000} \
    -yscrollcommand "$w.frame.canvas.vscrollbar set" \
    -xscrollcommand "$w.frame.canvas.hscrollbar set"
  
  pack append $w.frame.canvas \
    $w.frame.canvas.hscrollbar {top fillx} \
    $w.frame.canvas.vscrollbar {right filly} \
    $w.frame.canvas.text {left expand fill}
  #pack append $w.frame 
  
  pack append $w $w.frame {top fillx}
  pack append $w.frame \
    [button $w.frame.b1 -text "Exit" \
     -command "destroy $w" ] {top fillx} \
    $w.frame.canvas {top fillx}	
  
  update
  set num_rows [SQLexec exec_res $command]
  set num_cols [expr "[array size exec_res] / ($num_rows + 1)" ]
  
  # Find the largest fields for each column
  for { set i 0} { $i <= $num_rows } { set i [expr $i+1]} {
    for { set j 0 } { $j < $num_cols } {set j [expr $j+1]} {
      if { [catch {set dummy $len($j) }]} {
	set len($j) [string length $exec_res($i,$j)]
	
      } {
	if { [string length $exec_res($i,$j)] > $len($j)} {
	  set len($j) [string length $exec_res($i,$j)]
	}
      }
    }		
  }

  # Fill the array
  for { set i 0} { $i <= $num_rows } { set i [expr $i+1]} {
    set lineno [expr ($i+1)*12];
    set linetxt ""
    for { set j 0 } { $j < $num_cols } {set j [expr $j+1]} {
      append linetxt [format "%-*.*s |" $len($j) $len($j) $exec_res($i,$j)]
    }
    $w.frame.canvas.text create text  0 $lineno -anchor w \
      -font 9x15 \
      -text "$linetxt"
  }		
}


