/* -*-Mode: C;-*- immediate.sc -[Fri Oct  9 12:06:04 1992 by cxh]- */
#ifndef lint
static char     rcsid[] = "$Id: immediate.sc,v 1.4 1992/09/29 21:20:13 cxh Exp cxh $";
#endif
/*
 * Copyright 1992 Regents of the University of California. Permission to use,
 * copy, modify, and distribute this software and its documentation for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies.  The University of California makes
 * no representations about the suitability of this software for any purpose.
 * It is provided 'as is' without express or implied warranty.
 */

/*
 * This file consists of the sql specific code.  This file contains embedded
 * sql, it should be converted to a .c file by Ingres' esql. The functions at
 * the bottom are externally visible.
 */

#include "tclsql.h"
#include "coltype.h"

/* Include the sql communications area. */
EXEC SQL INCLUDE SQLCA;

/* Include the global data location typdef. */
EXEC SQL INCLUDE SQLDA;

/* curs.h must be included _after_ INCLUDE SQLCA and SQLDA */
#include "curs.h"


/*
 * Called by SQLdeleteCmd, SQLinsertCmd, SQLupdateCmd
 */
immediate(interp, argc, argv, cmd, usage)
     Tcl_Interp     *interp;
     int             argc;
     char          **argv;
     char	    *cmd, *usage;
{
  EXEC SQL BEGIN DECLARE SECTION;
  char            esqlcmd[BUFSIZ];
  EXEC SQL END DECLARE SECTION;
  char		  errmsg[BUFSIZ];
  char           *cbuf;


  EXEC SQL WHENEVER SQLERROR GOTO immediate_err;

  if (!strncasecmp( argv[1], "repeated", 8 )) {
    /* If the first word is "repeated", then create the command string
     * Without the first word
     */
    cbuf = Tcl_Concat(argc-2, argv+2);    
    if (strlen(cbuf + 7) > BUFSIZ) {
      Tcl_AppendResult(interp, argv[0], " ", cbuf, " : string too long", 0);
      return TCL_ERROR;
    }
    sprintf(esqlcmd, "repeated %s %s", cmd, cbuf);
  }else{
    cbuf = Tcl_Concat(argc-1, argv+1);
    if (strlen(cbuf + 7) > BUFSIZ) {
      Tcl_AppendResult(interp, argv[0], " ", cbuf, " : string too long", 0);
      return TCL_ERROR;
    }
    sprintf(esqlcmd, "%s %s", cmd, cbuf);
  }

  EXEC SQL execute immediate:esqlcmd;
  if (cbuf)
    free(cbuf);
  return TCL_OK;

immediate_err:
  EXEC SQL WHENEVER SQLERROR CONTINUE;
  sprintf(errmsg, "%s %s",argv[0], esqlcmd);
  sql_error(interp, errmsg);
  if (cbuf)
    free(cbuf);
  return TCL_ERROR;
}
