#source "conf.tcl"
initConf $argv

set editor .f.editor
frame .f
scrollbar .f.scroller -relief sunken -command ".f.editor yview"
text $editor  -width 20 \
    -font *helvetica*-r-*12* -yscrollcommand "scroller" -setgrid true

canvas .f.c -relief sunken -width 20 
set scrollid(self) [.f.c create rectangle 0 0 50 50 -fill red]
bind $editor <KeyPress> {doit %A; .f.editor yview -pickplace insert}
bind $editor <Return> {doit "\n"; .f.editor yview -pickplace insert}

gkDefaultMenu .menu
pack append .f $editor left .f.c {left filly} .f.scroller {left filly}
pack append . .menu {top fillx} .f {top} 

trace variable new_user w newscroll

proc doit {char} { global others editor
    $editor insert insert $char
    .f.editor yview -pickplace insert
    set insertion_point [$editor index insert]
    foreach i $others {	
	RDO [keylget i filedesc] $editor insert $insertion_point $char
    }
}

proc scroller args { global ouropts
    set totalUnits [lindex $args 0]
    set windowUnits [lindex  $args 1]
    set firstUnit [lindex $args 2]
    set lastUnit [lindex $args 3]
    scroll1 self $totalUnits $windowUnits $firstUnit $lastUnit
    foreach i [others] {	
	RDO [keylget i filedesc] scroll1 [keylget ouropts usernum] $totalUnits $windowUnits $firstUnit $lastUnit
    }
    eval ".f.scroller set $args"
}

proc newscroll args { global new_user scrollid
    set scrollid([keylget new_user usernum]) [.f.c create rectangle 0 0 50 50 -fill blue]
}

proc scroll1 {userid totalUnits windowUnits firstUnit lastUnit} { global scrollid
    set top [expr ($firstUnit.0/$totalUnits)*[winfo height .f.c]]
    set bott [expr ($lastUnit.0/$totalUnits)*[winfo height .f.c]]
    .f.c coord $scrollid($userid) 0 $top 50 $bott
}
    
