#-------------------------------------------------------------------------
#
# MODULE VIMmisc.tcl
#
# Convenience routines for the Visual Ising Machine
#
#-------------------------------------------------------------------------



#-----------------------------------------------------------------------------
# remote script
#
# execute <script> in remote interpreter
#
# Arguments:
#	script -	script to execute
#-----------------------------------------------------------------------------
proc remote {script} {
	global RemoteInterp
	set result [send $RemoteInterp $script]
	return $result
}

#-----------------------------------------------------------------------------
# mkStdErrorBox msg
#
# Build a standard error box
#
# Arguments:
#	msg -	message to display
#-----------------------------------------------------------------------------
proc mkStdErrorBox {msg} {
	set w .errorBox

	toplevel $w
	wm title $w "VIM \[Error!\]"
	grab $w
	
	set msgF [frame $w.msgF -relief raised -bd 1]
	message $msgF.msg -text $msg -relief sunken -bd 1 -width 300 \
		-font -*-helvetica-bold-r-normal-*-17-*-*-*-*-*-*-*
	
	set btns [tixDlgBtns $w.btns]
	$btns add close -text Close -width 7 \
		-command "destroy $w"
		
	pack $msgF.msg -fill both -expand yes -padx 20 -pady 20
	pack $msgF -side top -fill both -expand yes
	pack $w.btns -fill both -expand yes

}


#-----------------------------------------------------------------------------
#
#  setCursor w type
#
#  Change the mouse pointer over <w> to <type>
#
#  Arguments:
#	w -	window
#	type - 	type of bitmap for mouse pointer
#-----------------------------------------------------------------------------
proc setCursor {w type} {
	
	switch $type {
	{hand}	{$w configure -cursor sizing
		}
	{arrow} { $w configure -cursor arrow 
		}

	}
}
