#
# This module implements several dialog types.
#
# Michael Moore
# March 1993
#


proc prompt_delete {w char} {
    set i [catch {set f [$w index sel.first]}]
    set j [catch {set t [$w index sel.last]}]
    set string [$w get]
    if {$i || $j} {
	set t -1
	set f -1
    }
    if {$t != $f} {
	set new [string range $string 0 [expr $f-1]]
	append new [string range $string [expr $t+1] end]
    } else {
	set new [string range $string 0 [expr [string length $string]-2]]
    }
    $w delete 0 end
    $w insert 0 "$new$char"
    bind $w <Any-Key> "$w insert insert %A"
    bind $w <Key-Return> "set PromptReturn 1"
    bind $w <Key-Delete> "prompt_delete $w \"\""
    bind $w <Key-BackSpace> "prompt_delete $w \"\""
}


#
# The prompt dialog is used to query the user for an answer to
# a question.  It may be centered on the pointer, or in a 
# specific position on the screen, as specified in "place".
# The title string is placed in the dialog's title bar, and the
# prompt string is written to its message widget.  If default is
# provided it is placed inside the entry widget.
#
    
proc prompt_dialog {root aspect title prompt default} {
    global PromptReturn

    toplevel $root
    wm title $root $title

    # Determine the position of the pointer through our special
    # call.
    
    set pointer [query_pointer]
    set xpos [lindex $pointer 0]
    set ypos [lindex $pointer 1]
    incr xpos -10
    incr ypos -10
    
    # adjust for the location of the virtual window if necessary
    
    incr ypos [expr [winfo vrooty .]*-1]
    incr xpos [expr [winfo vrootx .]*-1]

    wm geometry $root "+$xpos+$ypos"
    
    # Now place the message widget and the prompt inside the toplevel
    # window.

    message $root.message -text $prompt -aspect $aspect -relief flat 
    entry $root.entry -relief sunken
    $root.entry insert 0 $default
    $root.entry select from 0 
    $root.entry select to end
    bind $root.entry <Any-Key> "prompt_delete $root.entry %A"
    bind $root.entry <Key-Return> "set PromptReturn 1"
    bind $root.entry <Key-Delete> "prompt_delete $root.entry \"\""
    bind $root.entry <Key-BackSpace> "prompt_delete $root.entry \"\""
    frame $root.buttons -relief flat
    button $root.buttons.okay -text "OK" -command {set PromptReturn 1}
    button $root.buttons.cancel -text "Cancel" -command {set PromptReturn 0}
    pack append $root.buttons \
	$root.buttons.okay {left} \
	$root.buttons.cancel {right}

    pack append $root \
	$root.message {top frame center} \
	$root.entry   {top frame center fillx expand} \
	$root.buttons {top frame center}

   update
    set sw [winfo screenwidth $root]
    set sh [winfo screenheight $root]
    set x [expr $xpos%$sw]
    set y [expr $ypos%$sh]
    set w [winfo reqwidth $root]
    set h [winfo reqheight $root]
    set xpos [winfo rootx $root]
    set ypos [winfo rooty $root]
    set xadj [expr $sw-[expr $w+$x]]
    set yadj [expr $sh-[expr $h+$y]]
    if {$xadj < 0} {
	incr xpos $xadj
    }
    set yadj -$yadj
    if {$yadj > 0} {
	incr ypos $yadj
    }
    wm geometry $root "${w}x${h}+$xpos+$ypos"


    focus $root.entry 
    grab set $root
    set PromptReturn 0
    tkwait variable PromptReturn
    grab release $root
    if {$PromptReturn == 1} {
	set ret [$root.entry get]
    } else {
	set ret ""
    }
    destroy $root
    return $ret
}


#
# This procedure presents the user with a set of options,
# one for each of the arguments in the arg list.
#

proc option_dialog {root aspect title message args} {
    global OptionReturn

    toplevel $root
    wm title $root $title
    
    # Determine the position of the pointer through our special call.
    
    set pointer [query_pointer]
    set xpos [lindex $pointer 0]
    set ypos [lindex $pointer 1]
    incr xpos -10
    incr ypos -10

    # adjust for the location of the virtual window if necessary
    
    incr ypos [expr [winfo vrooty .]*-1]
    incr xpos [expr [winfo vrootx .]*-1]

    wm geometry $root "+$xpos+$ypos"
    
    message $root.message -text $message -aspect $aspect -relief flat -borderwidth 8
    frame $root.buttons -relief flat -borderwidth 8
    set count 0
    foreach item $args {
	button $root.buttons.$count -text $item \
	    -command "set OptionReturn $count" -padx 4 -pady 2
	pack append $root.buttons \
	    $root.buttons.$count {left fillx expand}
	incr count
    }
    pack append $root \
	$root.message {top frame center} \
	$root.buttons {top frame center fillx expand}
 
    update
    set sw [winfo screenwidth $root]
    set sh [winfo screenheight $root]
    set x [expr $xpos%$sw]
    set y [expr $ypos%$sh]
    set w [winfo reqwidth $root]
    set h [winfo reqheight $root]
    set xpos [winfo rootx $root]
    set ypos [winfo rooty $root]
    set xadj [expr $sw-[expr $w+$x]]
    set yadj [expr $sh-[expr $h+$y]]
    if {$xadj < 0} {
	incr xpos $xadj
    }
    set yadj -$yadj
    if {$yadj > 0} {
	incr ypos $yadj
    }
    wm geometry $root "${w}x${h}+$xpos+$ypos"




    grab set $root
    set OptionReturn -1
    tkwait variable OptionReturn
    grab release $root
    set ret [lindex $args $OptionReturn]
    destroy $root
    return $ret
}
    
proc free_dialog {root aspect title message args} {
    global OptionReturn

    toplevel $root
    wm title $root $title
    
    # Determine the position of the pointer through our special call.
    
    set pointer [query_pointer]
    set xpos [lindex $pointer 0]
    set ypos [lindex $pointer 1]
    incr xpos -10
    incr ypos -10

    # adjust for the location of the virtual window if necessary
    
    incr ypos [expr [winfo vrooty .]*-1]
    incr xpos [expr [winfo vrootx .]*-1]
    
    # now adjust to keep it on the screen
    
    wm geometry $root "+$xpos+$ypos"
    
    message $root.message -text $message -aspect $aspect -relief flat
    frame $root.buttons -relief flat
    set count 0
    foreach item $args {
	button $root.buttons.$count -text $item \
	    -command "destroy $root"
	pack append $root.buttons \
	    $root.buttons.$count {left fillx expand}
	incr count
    }
    pack append $root \
	$root.message {top frame center} \
	$root.buttons {top frame center fillx expand}
    update
    set sw [winfo screenwidth $root]
    set sh [winfo screenheight $root]
    set x [expr $xpos%$sw]
    set y [expr $ypos%$sh]
    set w [winfo reqwidth $root]
    set h [winfo reqheight $root]
    set xpos [winfo rootx $root]
    set ypos [winfo rooty $root]
    set xadj [expr $sw-[expr $w+$x]]
    set yadj [expr $sh-[expr $h+$y]]
    if {$xadj < 0} {
	incr xpos $xadj
    }
    set yadj -$yadj
    if {$yadj > 0} {
	incr ypos $yadj
    }
    wm geometry $root "${w}x${h}+$xpos+$ypos"
}
    

