'\"
'\" Copyright 1990 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /rel/cvsfiles/unsupported/latest/tk/doc/winfo.n,v 1.1 1993/01/24 05:00:40 zoo Exp $ SPRITE (Berkeley)
'/" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS winfo cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
winfo \- Return window-related information
.SH SYNOPSIS
\fBwinfo\fR \fIoption \fR?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
The \fBwinfo\fR command is used to retrieve information about windows
managed by Tk.  It can take any of a number of different forms,
depending on the \fIoption\fR argument.  The legal forms are:
.TP
\fBwinfo atom \fIname\fR
.VS
Returns a decimal string giving the integer identifier for the
atom whose name is \fIname\fR.  If no atom exists with the name
\fIname\fR then a new one is created.
.TP
\fBwinfo atomname \fIid\fR
Returns the textual name for the atom whose integer identifier is
\fIid\fR.
This command is the inverse of the \fBwinfo atom\fR command.
Generates an error if no such atom exists.
.VE
.TP
\fBwinfo children \fIwindow\fR
Returns a list containing the path names of all the children
of \fIwindow\fR.  Top-level windows are returned as children
of their logical parents.
.TP
\fBwinfo class \fIwindow\fR
Returns the class name for \fIwindow\fR.
.TP
\fBwinfo containing \fIrootX rootY\fR
.VS
Returns the path name for the window containing the point given
by \fIrootX\fR and \fIrootY\fR.
\fIRootX\fR and \fIrootY\fR are specified in screen units (i.e.
any form acceptable to \fBTk_GetPixels\fR) in the coordinate
system of the root window.
If no window in this application contains the point then an empty
string is returned.
In selecting the containing window, children are given higher priority
than parents and among siblings the highest one in the stacking order is
chosen.
.TP
\fBwinfo exists \fIwindow\fR
Returns 1 if there exists a window named \fIwindow\fR, 0 if no such
window exists.
.TP
\fBwinfo fpixels \fIwindow\fR \fInumber\fR
Returns a floating-point value giving the number of pixels
in \fIwindow\fR corresponding to the distance given by \fInumber\fR.
\fINumber\fR may be specified in any of the forms acceptable
to \fBTk_GetScreenMM\fR, such as ``2.0c'' or ``1i''.
The return value may be fractional;  for an integer value, use
\fBwinfo pixels\fR.
.VE
.TP
\fBwinfo geometry \fIwindow\fR
Returns the geometry for \fIwindow\fR, in the form
\fIwidth\fBx\fIheight\fB+\fIx\fB+\fIy\fR.  All dimensions are
in pixels.
.TP
\fBwinfo height \fIwindow\fR
Returns a decimal string giving \fIwindow\fR's height in pixels.
.TP
\fBwinfo id \fIwindow\fR
Returns a hexadecimal string indicating the X identifier for \fIwindow\fR.
.TP
\fBwinfo interps\fR
Returns a list whose members are the names of all Tcl interpreters
(e.g. all Tk-based applications) currently registered for the
display of the invoking application.
.TP
\fBwinfo ismapped \fIwindow\fR
Returns \fB1\fR if \fIwindow\fR is currently mapped, \fB0\fR otherwise.
.TP
\fBwinfo name \fIwindow\fR
Returns \fIwindow\fR's name (i.e. its name within its parent, as opposed
to its full path name).
.VS
The command \fBwinfo name .\fR will return the name of the application.
.VE
.TP
\fBwinfo parent \fIwindow\fR
Returns the path name of \fIwindow\fR's parent, or an empty string
if \fIwindow\fR is the main window of the application.
.TP
\fBwinfo pathname \fIid\fR
Returns the path name of the window whose X identifier is \fIid\fR.
\fIId\fR must be a decimal, hexadecimal, or octal integer and must
correspond to a window in the invoking application.
.TP
\fBwinfo pixels \fIwindow\fR \fInumber\fR
.VS
Returns the number of pixels in \fIwindow\fR corresponding
to the distance given by \fInumber\fR.
\fINumber\fR may be specified in any of the forms acceptable
to \fBTk_GetPixels\fR, such as ``2.0c'' or ``1i''.
The result is rounded to the nearest integer value;  for a
fractional result, use \fBwinfo fpixels\fR.
.VE
.TP
\fBwinfo reqheight \fIwindow\fR
Returns a decimal string giving \fIwindow\fR's requested height,
in pixels.  This is the value used by \fIwindow\fR's geometry
manager to compute its geometry.
.TP
\fBwinfo reqwidth \fIwindow\fR
Returns a decimal string giving \fIwindow\fR's requested width,
in pixels.  This is the value used by \fIwindow\fR's geometry
manager to compute its geometry.
.TP
\fBwinfo rgb \fIwindow color\fR
.VS
Returns a list containing three decimal values, which are the
red, green, and blue intensities that correspond to \fIcolor\fR in
the window given by \fIwindow\fR.  \fIColor\fR
may be specified in any of the forms acceptable for a color
option.
.VE
.TP
\fBwinfo rootx \fIwindow\fR
Returns a decimal string giving the x-coordinate, in the root
window of the screen, of the
upper-left corner of \fIwindow\fR's border (or \fIwindow\fR if it
has no border).
.TP
\fBwinfo rooty \fIwindow\fR
Returns a decimal string giving the y-coordinate, in the root
window of the screen, of the
upper-left corner of \fIwindow\fR's border (or \fIwindow\fR if it
has no border).
.TP
\fBwinfo screen \fIwindow\fR
Returns the name of the screen associated with \fIwindow\fR, in
the form \fIdisplayName\fR.\fIscreenIndex\fR.
.TP
\fBwinfo screencells \fIwindow\fR
.VS
Returns a decimal string giving the number of cells in the default
color map for \fIwindow\fR's screen.
.TP
\fBwinfo screendepth \fIwindow\fR
Returns a decimal string giving the depth of the root window
of \fIwindow\fR's screen.
.TP
\fBwinfo screenheight \fIwindow\fR
Returns a decimal string giving the height of \fIwindow\fR's screen,
in pixels.
.TP
\fBwinfo screenmmheight \fIwindow\fR
Returns a decimal string giving the height of \fIwindow\fR's screen,
in millimeters.
.TP
\fBwinfo screenmmwidth \fIwindow\fR
Returns a decimal string giving the width of \fIwindow\fR's screen,
in millimeters.
.TP
\fBwinfo screenvisual \fIwindow\fR
Returns one of the following strings to indicate the default visual
type for \fIwindow\fR's screen: \fBdirectcolor\fR, \fBgrayscale\fR,
\fBpseudocolor\fR, \fBstaticcolor\fR, \fBstaticgray\fR, or
\fBtruecolor\fR.
.TP
\fBwinfo screenwidth \fIwindow\fR
Returns a decimal string giving the width of \fIwindow\fR's screen,
in pixels.
.TP
\fBwinfo toplevel \fIwindow\fR
Returns the path name of the top-level window containing \fIwindow\fR.
.TP
\fBwinfo vrootheight \fIwindow\fR
Returns the height of the virtual root window associated with \fIwindow\fR
if there is one;  otherwise returns the height of \fIwindow\fR's screen.
.TP
\fBwinfo vrootwidth \fIwindow\fR
Returns the width of the virtual root window associated with \fIwindow\fR
if there is one;  otherwise returns the width of \fIwindow\fR's screen.
.TP
\fBwinfo vrootx \fIwindow\fR
Returns the x-offset of the virtual root window associated with \fIwindow\fR,
relative to the root window of its screen;  returns 0 if there is no virtual
root window for \fIwindow\fR.
.TP
\fBwinfo vrooty \fIwindow\fR
Returns the y-offset of the virtual root window associated with \fIwindow\fR,
relative to the root window of its screen;  returns 0 if there is no virtual
root window for \fIwindow\fR.
.VE
.TP
\fBwinfo width \fIwindow\fR
Returns a decimal string giving \fIwindow\fR's width in pixels.
.TP
\fBwinfo x \fIwindow\fR
Returns a decimal string giving the x-coordinate, in \fIwindow\fR's
parent, of the
upper-left corner of \fIwindow\fR's border (or \fIwindow\fR if it
has no border).
.TP
\fBwinfo y \fIwindow\fR
Returns a decimal string giving the y-coordinate, in \fIwindow\fR's
parent, of the
upper-left corner of \fIwindow\fR's border (or \fIwindow\fR if it
has no border).

.SH KEYWORDS
atom, children, class, geometry, height, identifier, information, interpreters,
mapped, parent, path name, screen, virtual root, width, window
