/* 
 * mxManager.c --
 *
 *	The mx Manager keeps track of users of the mxedit editor.
 *
 * Copyright (c) 1992 Xerox Corporation.
 * Use and copying of this software and preparation of derivative works based
 * upon this software are permitted. Any distribution of this software or
 * derivative works must comply with all applicable United States export
 * control laws. This software is made available AS IS, and Xerox Corporation
 * makes no warranty about the software, its performance or its conformity to
 * any specification.
 */

#ifndef lint
static char rcsid[] = "$Header: /project/tcl/src/mxedit/RCS/mxManager.c,v 2.1 1993/05/19 16:30:49 welch Exp $ SPRITE (Berkeley)";
#endif

#include "tkConfig.h"
#include "tkInt.h"
#include "mxWidget.h"

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>

#include <ndbm.h>
#include <pwd.h>

/*
 * Two data bases are kept, a per-system record of mxedit users,
 * and a per-user record of mxedit sessions.
 */
static DBM *dbSystem;
static DBM *dbUser;

/*
 * MxManagerRecordSession --
 *	Update information about mxedit usage.
 */
int
MxManagerRecordSession(oldInterp, interp, display)
    Tcl_Interp *oldInterp, *interp;
    char *display;		/* X display name */
{
    char *libDir;
    struct passwd *passwdPtr;
    char *enableString;
    datum key, value;
    char pathname[1024];

    enableString = Tcl_GetVar(interp, "mxDbSystemEnabled", TCL_GLOBAL_ONLY);
    if (enableString) {
	if (!atoi(enableString)) {
	    return;
	}
    }
    if (dbSystem == NULL) {
	libDir = Tcl_GetVar(interp, "mxLibrary", TCL_GLOBAL_ONLY);
	if (libDir == NULL) {
	    fprintf(stderr, "MxManagerRecordSession: no mxedit_library\n");
	    return;
	}
	strcpy(pathname, libDir);
	strcat(pathname, "/mxdb");
	dbSystem = dbm_open(pathname, O_RDWR|O_CREAT, 0666);
	if (dbSystem == NULL) {
	    fprintf(stderr, "dbm_open(%s) failed", pathname);
	    perror("");
	    dbSystem = (DBM *)-1;
	}
    }
    if (oldInterp != NULL) {
	char *val;
	val = Tcl_GetVar(oldInterp, "mxDbSystemEntry", TCL_GLOBAL_ONLY);
	if (val) {
	    Tcl_SetVar(interp, "mxDbSystemEntry", val, TCL_GLOBAL_ONLY);
	    return;
	}
    }
    if (dbSystem == (DBM *)-1 || dbSystem == NULL) {
	return;
    }
    passwdPtr = getpwuid(getuid());
    if (passwdPtr == NULL) {
	fprintf(stderr, "getpwuid(%d) failed\n", getuid());
    } else {
	int numSessions;
	struct timeval timeval;
	char hostname[80];
	char keystr[1024];
	char newRecord[DBLKSIZ];

	gethostname(hostname, 79); hostname[79] = '\0';
	strcpy(keystr, passwdPtr->pw_name);
	strcat(keystr, " ");
	if (display == NULL) {
	    display = getenv("DISPLAY");
	    if (display == NULL) {
		display = ":0";
	    }
	}
	strcat(keystr, display);
	key.dsize = strlen(keystr)+1;
	key.dptr = keystr;
	value = dbm_fetch(dbSystem, key);
	if (value.dptr != NULL) {
	    /*
	     * Update record about the user.
	     */
	    if (sscanf(value.dptr, "%*s uses %d", &numSessions) == 1) {
		numSessions++;
	    } else {
		numSessions = 1;
	    }
	} else {
	    numSessions = 1;
	}
	gettimeofday(&timeval, 0);
	sprintf(newRecord, "%s uses %d host %s display %s lastDate %s",
	    passwdPtr->pw_name, numSessions, hostname, display,
	    ctime(&timeval.tv_sec));
	value.dptr = newRecord;
	value.dsize = 1+strlen(newRecord);
	if (dbm_store(dbSystem, key, value, DBM_REPLACE) != 0) {
	    fprintf(stderr, "dbm_store(dbSystem...) failed\n");
	}
	Tcl_SetVar(interp, "mxDbSystemKey", keystr, TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "mxDbSystemEntry", newRecord, TCL_GLOBAL_ONLY);
    }
}
/*
 * MxManagerRecordOpen --
 *	Update information about mxedit usage.
 */
int
MxManagerRecordOpen(interp, display, appname)
    Tcl_Interp *interp;
    char *display;
    char *appname;
{
    char *libDir;
    struct passwd *passwdPtr;
    char *pathname;
    char *enableString;
    datum key, value;
    int numSessions;
    struct timeval timeval;
    char hostname[80];
    char keystr[1024];
    char newRecord[DBLKSIZ];

    enableString = Tcl_GetVar(interp, "mxDbUserEnabled", TCL_GLOBAL_ONLY);
    if (enableString) {
	if (!atoi(enableString)) {
	    return;
	}
    }
    if (dbUser == NULL) {
	pathname = Tcl_TildeSubst(interp, "~/.mxdb");
	dbUser = dbm_open(pathname, O_RDWR|O_CREAT, 0666);
	if (dbUser == NULL) {
	    fprintf(stderr, "dbm_open(%s) failed", pathname);
	    perror("");
	    dbUser = (DBM *)-1;
	}
    }
    if (dbUser == (DBM *)-1 || dbUser == NULL) {
	return;
    }
    /*
     * Key is "appname| display"
     * The '|' is used as a delimiter because appname can have spaces
     * but it cannot have '|'.
     */
    strcpy(keystr, appname);
    strcat(keystr, "| ");
    if (display == NULL) {
	display = getenv("DISPLAY");
	if (display == NULL) {
	    display = ":0";
	}
    }
    strcat(keystr, display);
    key.dsize = strlen(keystr)+1;
    key.dptr = keystr;
    gettimeofday(&timeval, 0);
    gethostname(hostname, 79); hostname[79] = '\0';
    sprintf(newRecord, "%s| host %s display %s active %s",
	appname, hostname, display,
	ctime(&timeval.tv_sec));
    value.dptr = newRecord;
    value.dsize = 1+strlen(newRecord);
    if (dbm_store(dbUser, key, value, DBM_REPLACE) != 0) {
	fprintf(stderr, "dbm_store(dbUser...) failed\n");
    }
    Tcl_SetVar(interp, "mxDbUserKey", keystr, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "mxDbUserEntry", newRecord, TCL_GLOBAL_ONLY);
}
/*
 * MxManagerRecordSwitch --
 *	Update information about mxedit usage.
 */
int
MxManagerRecordSwitch(interp, newAppname)
    Tcl_Interp *interp;
    char *newAppname;
{
    MxManagerRecordClose(interp);
    MxManagerRecordOpen(interp, NULL, newAppname);
}
/*
 * MxManagerRecordClose --
 *	Update information about mxedit usage.
 */
int
MxManagerRecordClose(interp)
    Tcl_Interp *interp;
{
    char *libDir;
    datum key, value;
    struct timeval timeval;
    char *keystr;
    char *fields;
    char appname[1024];
    char hostname[128], display[128];
    char newRecord[DBLKSIZ];

    keystr = Tcl_GetVar(interp, "mxDbUserKey", TCL_GLOBAL_ONLY);
    if (dbUser == (DBM *)-1 || dbUser == NULL || keystr == NULL) {
	return;
    }
    key.dptr = keystr;
    key.dsize = strlen(keystr)+1;
    value = dbm_fetch(dbUser, key);
    if (value.dptr == NULL) {
	return;
    }
    fields = strstr(value.dptr, "|");	/* skip over appname */
    if (fields == NULL) {
	return;
    }
    strncpy(appname, value.dptr, fields - value.dptr);
    appname[fields - value.dptr] = '\0';
    for (fields++ ; *fields == ' '; fields++) { }
    sscanf(fields, "host %s display %s", hostname, display);
    gettimeofday(&timeval, 0);
    sprintf(newRecord, "%s| host %s display %s closed %s",
	appname, hostname, display,
	ctime(&timeval.tv_sec));
    value.dptr = newRecord;
    value.dsize = 1+strlen(newRecord);
    if (dbm_store(dbUser, key, value, DBM_REPLACE) != 0) {
	fprintf(stderr, "dbm_store(dbUser...) failed\n");
    }
}
