#include <time.h>
#include <socket.h>		/* for timeval structure */
#include <descrip>
#include <stdio>
#include <time>
#include <vmstypes>
#include <ssdef>
/*
   gettimeofday - get date and time

   This returns the current Greenwich time.  Time is expressed in seconds
   and microseconds since midnight Jan. 1, 1970.

   Some assumptions that are made here.

      o  The system clock is set at local time.

      o  There is a logical name SYS$TIME_ZONE which indicates the number
         of hours offset from Greenwich.  This is a four digit number
         which is of the form "SHHMM", where S is a negative sign
         if we are West of Greenwich, HHMM is the number of hours
         and minutes offset from Greenwich.

      o  The SYS$TIME_ZONE indicates the number of hours East of Greenwich.
         This means if we are West of Greenwich the SYS$TIME_ZONE
         value should be negative.
*/
static int minutesWest = -1;

int gettimeofday (struct timeval *tp, struct timezone *tzp)
{
    char    *sptr;
    timeb_t time;
    long    zone_off = 0;
    long    hh, mm;

    ftime (&time);

    tp->tv_sec = time.time;
    tp->tv_usec = time.millitm * 1000;

    if (minutesWest == -1) {
       if ((sptr = getenv ("SYS$TIME_ZONE")) != NULL) {
           sscanf (sptr, "%d", &zone_off);
           free (sptr);
       }
       else {
           printf("Logical name SYS$TIME_ZONE does not exist\n");
           exit(-1); 
       } 
       hh = zone_off / 100;
       mm = zone_off % 100 * ((zone_off > 0) ? 1 : -1);
       minutesWest = hh * -60 + mm;
    }
    if (tzp != 0)
       {
       if ((sptr = getenv ("SYS$TIME_ZONE")) != NULL) {
           sscanf (sptr, "%d", &zone_off);
           free (sptr);
       }
       hh = zone_off / 100;
       mm = zone_off % 100 * ((zone_off > 0) ? 1 : -1);

       tzp->tz_minuteswest = minutesWest;
       tzp->tz_dsttime     = 0;
       }

    tp->tv_sec += 60 * minutesWest;

    return 0;
    
}

/*
   settimeofday - get date and time

   This returns the current Greenwich time.  Time is expressed in seconds
   and microseconds since midnight Jan. 1, 1970.

   Some assumptions that are made here.

      o  The system clock is set at local time.

      o  There is a logical name SYS$TIME_ZONE which indicates the number
         of hours offset from Greenwich.  This is a four digit number
         which is of the form "SHHMM", where S is a negative sign
         if we are West of Greenwich, HHMM is the number of hours
         and minutes offset from Greenwich.

      o  The SYS$TIME_ZONE indicates the number of hours East of Greenwich.
         This means if we are West of Greenwich the SYS$TIME_ZONE
         value should be negative.

*/
int settimeofday (struct timeval *tp,struct timezone *notused)
{
    static int baseTime[2] = {0x4BEB4000,0x007C9567};
    char    *sptr;
    long    zone_off = 0;
    long    hh, mm;
    int     seconds = tp -> tv_sec;               /* Seconds                 */
    int     nanoSeconds = tp -> tv_usec *10;      /* Hundreds of nanoseconds */
    int     internalTime[2];
    int     returnCode = 0;
    int     status;

    if (minutesWest == -1) {
        if ((sptr = getenv ("SYS$TIME_ZONE")) != NULL) {        
            sscanf (sptr, "%d", &zone_off);
            free (sptr);
        }
        else {
           printf("Logical name SYS$TIME_ZONE does not exist\n");
           exit(-1); 
        } 
        hh = zone_off / 100;
        mm = zone_off % 100 * ((zone_off > 0) ? 1 : -1);
        minutesWest = hh * -60 + mm;
    }

    seconds -= 60 * minutesWest;
    
    lib$emul (&10000000,&seconds,&nanoSeconds,internalTime);    
    lib$addx (baseTime,internalTime,internalTime);

    status = sys$setime(internalTime);
    if (status != 0) returnCode = 1;

    return returnCode;
}
