/* Copyright (c) 1993 by Sanjay Ghemawat */

#ifndef _CALENDARH
#define _CALENDARH

#include <stdio.h>
#include "basic.h"
#include "unparsed.h"

class Item;
class Lexer;
class pointerArray;
class UidSet;

class Calendar {
  public:
    Calendar();			/* Create a new calendar */
    ~Calendar();

    /*
     * Item list.
     */
    int Size() const;			/* Number of items */
    Item* Get(int) const;		/* Get the ith item */
    void Add(Item*);			/* Add an item */
    void Remove(Item*);			/* Remove an item */

    /*
     * Included calendars.
     */
    void Include(char const*);
    void Exclude(char const*);

    int  NumIncludes() const;
    char const* GetInclude(int) const;

    /*
     * True iff this calendar is read-only.
     */
    int ReadOnly() const;
    void SetReadOnly(int);

    /*
     * Read/Write.
     */
    int Read(Lexer*);
    void Write(FILE*) const;

    int Hidden(char const* uid) const;
    // effects - Returns true iff item named by uid should be hidden.

    void Hide(char const* uid);
    // effects - Add specified uid to set of uids of hidden items.

    int AmPmMode() const;
    // effects - Returns true iff time should be displayed in am/pm mode

    void AmPmMode(int x);
    // modifies	- this
    // effects	- Display time in am/pm mode iff x is true.

    int MondayFirst() const;
    // effects - Returns true iff week should start on Monday.
    //		 (Week can start either on Sunday or Monday.)

    void MondayFirst(int m);
    // modifies	- this
    // effects	- From now on, week starts on Monday iff m.
  protected:
    pointerArray& items;		// Items
    pointerArray& includes;		// Included calendars
    int readonly;			// Readonly calendar?
    UidSet*	  hidden;		// Hidden items from other calendars
    int		  ampm;			// Display am/pm?
    int		  mondayFirst;		// Week starts with Monday?

    // Extra things read from file but not understood.
    UnparsedItems extra;
};

inline int Calendar::ReadOnly() const {
    return readonly;
}

inline void Calendar::SetReadOnly(int t) {
    readonly = t;
}

inline int Calendar::AmPmMode() const {
    return ampm;
}

inline void Calendar::AmPmMode(int m) {
    ampm = m ? 1 : 0;
}

inline int Calendar::MondayFirst() const {
    return mondayFirst;
}

inline void Calendar::MondayFirst(int m) {
    mondayFirst = m ? 1 : 0;
}

#endif /* _CALENDARH */
