# UserMaint V1.0 by Charles A. Eads
#
# Copyright (c) 1993 The Regents of the University of California.
# All rights reserved.
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose, without fee, and without written agreement is
# hereby granted, provided that the above copyright notice and the following
# two paragraphs appear in all copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
# CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

proc capitalize {s} \
{
	return [string toupper [string range $s 0 0]][string range $s 1 end]
}

proc pad_space {s l b} \
{
	set SPACE "                                                   "
	set s [string range $s$SPACE 0 [expr $l-1]][string range $SPACE 0 [expr $b-1]]
}

proc lnumsort {l} \
{
	set bin_list {}
	set l [lsort $l]
	foreach l_entry $l \
	{
		set length [string length $l_entry]
		if [lsearch $bin_list $length]==-1 \
		{
			lappend bin_list $length
			set sl($length) $l_entry
		} \
		{
			lappend sl($length) $l_entry
		}
	}
	set bin_list [lsort $bin_list]
	set l {}
	foreach bin $bin_list \
	{
		set l [concat $l $sl($bin)]
	}
	return $l
}

proc lreverse {l} \
{
	set nl {}
	foreach l_entry $l \
	{
		set nl [linsert $nl 0 $l_entry]
	}
	return $nl
}

proc lunion {l1 l2} \
{
	foreach i $l2 \
	{
		if [lsearch $l1 $i]==-1 {lappend l1 $i}
	}
	return $l1
}

proc lremove_spaces {l} \
{
	set l [linsert $l 0 temp_entry]
	set l [eval "concat $l"]
	set l [lreplace $l 0 0]
}

proc file_to_list {file_text} \
{
	regsub -all { } $file_text \b file_text
	return $file_text
}

proc file_to_normal {file_text} \
{
	regsub -all \b $file_text { } file_text
	return $file_text
}

proc file_get_element {file_entry element} \
{
	set file_entry [file_to_list $file_entry]
	regsub -all :: $file_entry :\v: file_entry
	regsub -all :: $file_entry :\v: file_entry
	set file_entry [lindex [split $file_entry {:}] $element]
	regsub -all \v $file_entry {} file_entry
	return [file_to_normal $file_entry]
}

proc rand {range} \
{
	return [exec perl -e "srand(time|\$\$); srand(time*rand()); print int(rand($range)),\"\\n\";"]
}

proc backspace {w} {
    set x [expr {[$w index insert] - 1}]
    if {$x != -1} {$w delete $x}
}

proc filter_ascii {key} \
{
	if { ($key>=" ") && ($key<="~") } \
	{
		return $key
	}
	return {}
}

proc bind.entry args {
    foreach w $args {
        bind $w <Any-KeyPress> {%W insert [%W index insert] [filter_ascii "%A"]}
        bind $w <quotedbl> {%W insert [%W index insert] \"}
        bind $w <backslash> {%W insert [%W index insert] \\}
        bind $w <dollar> {%W insert [%W index insert] {$}}
        bind $w <space> {%W insert [%W index insert] " "}
        bind $w <2> {puts stdout "character [%W index @%x]"}
        bind $w <Delete> {backspace %W}
        bind $w <BackSpace> {backspace %W}
        bind $w <Control-h> {backspace %W}
        bind $w <1> {%W icursor @%x; focus %W; %W select from @%x}
        bind $w <B1-Motion> {%W select to @%x}
        bind $w <Shift-1> {%W select adjust @%x}
        bind $w <Shift-B1-Motion> {%W select to @%x}
        bind $w <3> {%W scan mark %x}
        bind $w <B3-Motion> {%W scan dragto %x}
        bind $w <Control-d> {%W delete sel.first sel.last}
        bind $w <Control-v> {%W insert [%W index insert] [selection get]}
        bind $w <Control-u> {%W delete 0 end}
    }
}

proc filter_ascii_lowercase {key entry} \
{
	if { [string length $entry] >= 8 } return {}
	if { ( ($key>="a") && ($key<="z") ) || ( ($key>="A") && ($key<="Z") ) || ($key=="-") } \
	{
		return [string tolower $key]
	}
	return {}
}

proc bind.entry_lowercase args {
    foreach w $args {
        bind $w <Any-KeyPress> {%W insert [%W index insert] [filter_ascii_lowercase "%A" [%W get]]}
        bind $w <quotedbl> {%W insert [%W index insert] {}}
        bind $w <backslash> {%W insert [%W index insert] {}}
        bind $w <dollar> {%W insert [%W index insert] {}}
        bind $w <space> {%W insert [%W index insert] ""}
        bind $w <2> {puts stdout "character [%W index @%x]"}
        bind $w <Delete> {backspace %W}
        bind $w <BackSpace> {backspace %W}
        bind $w <Control-h> {backspace %W}
        bind $w <1> {%W icursor @%x; focus %W; %W select from @%x}
        bind $w <B1-Motion> {%W select to @%x}
        bind $w <Shift-1> {%W select adjust @%x}
        bind $w <Shift-B1-Motion> {%W select to @%x}
        bind $w <3> {%W scan mark %x}
        bind $w <B3-Motion> {%W scan dragto %x}
        bind $w <Control-d> {%W delete sel.first sel.last}
        bind $w <Control-v> {%W insert [%W index insert] [selection get]}
        bind $w <Control-u> {%W delete 0 end}
    }
}

proc filter_ascii_numeric {key entry} \
{
	if { ($key>="0") && ($key<="9") } \
	{
		if {$entry != {}} {if {[expr "$entry * 10 + $key"] > 65535} return {}}
		return [string tolower $key]
	}
	return {}
}

proc bind.entry_numeric args {
    foreach w $args {
        bind $w <Any-KeyPress> {%W insert [%W index insert] [filter_ascii_numeric "%A" [%W get]]}
        bind $w <quotedbl> {%W insert [%W index insert] {}}
        bind $w <backslash> {%W insert [%W index insert] {}}
        bind $w <dollar> {%W insert [%W index insert] {}}
        bind $w <space> {%W insert [%W index insert] ""}
        bind $w <2> {puts stdout "character [%W index @%x]"}
        bind $w <Delete> {backspace %W}
        bind $w <BackSpace> {backspace %W}
        bind $w <Control-h> {backspace %W}
        bind $w <1> {%W icursor @%x; focus %W; %W select from @%x}
        bind $w <B1-Motion> {%W select to @%x}
        bind $w <Shift-1> {%W select adjust @%x}
        bind $w <Shift-B1-Motion> {%W select to @%x}
        bind $w <3> {%W scan mark %x}
        bind $w <B3-Motion> {%W scan dragto %x}
        bind $w <Control-d> {%W delete sel.first sel.last}
        bind $w <Control-v> {%W insert [%W index insert] [selection get]}
        bind $w <Control-u> {%W delete 0 end}
    }
}

proc query {msg} \
{
	global BACKGROUND_COLOR_ADD_EDIT
	upvar #0 window_number wnumber
	set w .query-$wnumber
	catch {destroy .message}
	toplevel $w
	wm transient $w .
	wm title $w ""
	set wnumber_save $wnumber
	incr wnumber

	frame $w.query -border 5 -background $BACKGROUND_COLOR_ADD_EDIT
	label $w.query.message -relief raised -text $msg
	pack append $w.query $w.query.message {top expand fillx}

	frame $w.control -border 5 -background $BACKGROUND_COLOR_ADD_EDIT
	button $w.control.yes -width 10 -text "YES" -command "set answer($w) 1"
	button $w.control.no -width 10 -text "NO" -command "set answer($w) 2"
	pack append $w.control $w.control.yes {left} $w.control.no {right}

	pack append $w $w.query {top expand fillx} $w.control {bottom expand fillx}

	uplevel #0 "set i 0; bind $w <Any-Map> {set i 1}; tkwait variable i"
	wm geometry $w "+[expr "(1280 - [winfo width $w]) / 2"]+10"
	update
	set answer [uplevel #0 "set answer($w) 0; tkwait variable answer($w); set answer($w)"]

	destroy $w

	if {$answer == 2} {set answer 0}
	return $answer
}

proc create_message {msg} \
{
	global BACKGROUND_COLOR_ADD_EDIT
	destroy_message

	toplevel .message
	wm transient .message .
	wm title .message ""
	frame .message.message -border 5 -background $BACKGROUND_COLOR_ADD_EDIT
	label .message.message.msg -relief raised -text $msg -font -*-times-bold-*-*-*-*-180-*-*-*-*-*-*
	pack append .message.message .message.message.msg {top expand fillx}
	pack append .message .message.message {top expand fillx}
	bind .message <Any-Button-1> "destroy_message"
	bind .message.message <Any-Button-1> "destroy_message"
	bind .message.message.msg <Any-Button-1> "destroy_message"
	uplevel #0 "set i 0; bind .message <Any-Map> {set i 1}; tkwait variable i"
	wm geometry .message "+[expr "(1280 - [winfo width .message]) / 2"]+10"
	update
}

proc destroy_message {} \
{
	catch {destroy .message}
}

proc follow {w index ysize} \
{
	set current [$w nearest 0]
	if {$index < $current} {set index $current} else {
	if {$index >= [expr "$current + $ysize"]} {set index [expr "$index - $ysize + 1"]} else { return }}
	$w yview $index
}
