#!/usr/local/bin/wish -f
#
# MAP WINDOW
#
#


proc xMap  {} {

    global map_open

    catch {destroy .cMap}
    toplevel .cMap
    wm geometry .cMap +100+100
    wm title .cMap "MAP"
    wm iconname .cMap "MAP"
    wm minsize .cMap 200 200


    message .cMap.msg  \
	    -font -Adobe-helvetica-medium-r-normal--*-120* \
	    -aspect 700 -relief raised -bd 2 \
	    -text "This MAP window shows in graphical form the network. Lines represent traffic from source node (left) to destination node (right)."


    frame .cMap.bframe -relief raised -bd 2

    button .cMap.quit -text "QUIT" -command {
	set map_open 0
	destroy .cMap
    }


    pack .cMap.msg -side top -fill both
    pack .cMap.bframe -side top -fill both -expand yes
    pack .cMap.quit -side left -expand yes \
	    -fill both -pady 5


    #
    # Create the canvas which is place in the middle, between the text above
    # and the button which are place below the canvas.
    #
    scrollbar .cMap.bframe.vscroll \
	    -relief sunken -command ".cMap.bframe.c yview"

    canvas .cMap.bframe.c -width 350 -height 300 \
	    -yscroll ".cMap.bframe.vscroll set"

    pack .cMap.bframe.vscroll -side right -fill y
    pack .cMap.bframe.c -in .cMap.bframe -expand yes -fill both

    .cMap.bframe.c create text 25 10 \
	    -text "SOURCE" -fill black \
	    -anchor w -font -Adobe-helvetica-medium-r-normal--*-100*

    .cMap.bframe.c create text 265 10 \
	    -text "DESTINATION" -fill black \
	    -anchor w  -font -Adobe-helvetica-medium-r-normal--*-100*

    # Window open, ready to accept data
    set map_open 1

    # Display nodes if any
    map_insert

    # end map initialize procedure
}





# This procedure clears all nodes and lines on the map \
	in preparation for a screen update
proc clear_map_data {} {

    .cMap.bframe.c delete map_data
}





proc map_insert {} {

    global xNet_stopped \
	    conn_cnt \
	    conn_arr


    # return if no nodes to display
    if {$xNet_stopped} {return}

    set src_col 10
    set dest_col 290
    set src_cnt_col 80
    set dest_cnt_col 275
    set row_pos 30
    set row_skip 25

    set map_font -Adobe-helvetica-medium-r-normal--*-100*

    # Clear (delete) old map data and draw new map everytime
    clear_map_data

    for {set i 0} {$i < $conn_cnt} {incr i} {

	# if this is a source node with destinations, \
		draw lines
	if {$conn_arr("0,$i,1") > 0} {

	    set map_fill blue

	    # draw lines from source to every destination
	    set d_ptr 3
	    for {set j 0} {$j < $conn_arr("0,$i,1")} {incr j} {

		# get dest. ptr
		set dest $conn_arr("0,$i,$d_ptr")

		# initilize to 1st dest.
		set c_ptr 3

		# assume not a connection node
		set conn_node 0

		# search dest. as source for return path
		for {set k 0} {$k < $conn_arr("0,$dest,1")} {incr k} {
		    if {$conn_arr("0,$dest,$c_ptr") == $i} {
			set conn_node 1
			break
		    } else {
			incr c_ptr 4
		    }
		}

		# we now know if connection exists
		if {$conn_node} {
		    set line_clr black
		    set line_wid 2
		} else {
		    set line_clr brown
		    set line_wid 1
		}

		.cMap.bframe.c create line $src_cnt_col $row_pos \
			$dest_cnt_col [expr $conn_arr("0,$i,$d_ptr") * \
			$row_skip + $row_skip + 5] \
			-fill $line_clr -width $line_wid -tag map_data

		incr d_ptr 4
	    }

	} else {

	    set map_fill brown
	}


	# display all nodes on left side
	.cMap.bframe.c create text $src_col $row_pos \
		-text $conn_arr("0,$i,0") \
		-anchor w -font $map_font -fill $map_fill \
		-tag map_data

	# display all nodes on right side
	.cMap.bframe.c create text $dest_col $row_pos \
		-text $conn_arr("0,$i,0") \
		-anchor w -font $map_font -fill $map_fill \
		-tag map_data

	# display number of connections "FROM" this node
	.cMap.bframe.c create text $src_cnt_col  $row_pos \
		-text $conn_arr("0,$i,1") \
		-anchor e -font $map_font -fill black \
		-tag map_data

	# display number of connections "TO" this node
	.cMap.bframe.c create text $dest_cnt_col $row_pos \
		-text $conn_arr("0,$i,2") \
		-anchor w -font $map_font -fill brown \
		-tag map_data

	incr row_pos $row_skip
    }
    # end map insert procedure
}
