#!/usr/local/bin/wish -f
#
# GRAPH WINDOW
#
# This prodecure all the user to display in graph form network utilization
#

proc xGraf {} {

    global graf_open

    catch {destroy .cGraf}
    toplevel .cGraf
    wm geometry .cGraf +400+400
    wm title .cGraf "Utilization Graph"
    wm iconname .cGraf "GRAPH"


    message .cGraf.msg \
	    -font -Adobe-helvetica-Medium-R-Normal-*-120-* \
	    -aspect 1000 -bd 2 -relief raised \
	    -text "This window displays relative network utilization. The radio baud rate should be set correctly, see PREFS menu."


    canvas .cGraf.c -relief raised -width 400 -height 300

    button .cGraf.quit -text "QUIT" -command {
	set graf_open 0
	destroy .cGraf
    }

    button .cGraf.1hr -text "1 HR" -command {
	graf1
    }

    button .cGraf.5hr -text "5 HR" -command {
	graf5
    }

    button .cGraf.25hr -text "25 HR" -command {
	graf25
    }

    pack .cGraf.msg .cGraf.c -side top -fill x
    pack .cGraf.quit .cGraf.1hr .cGraf.5hr .cGraf.25hr \
	    -side left -expand yes -fill both -pady 5

    # set flag, graf window open now open, then call default graph.
    set graf_open 1
    graf1
}



# This procedure clears only the data (lines) on the graph \
	the x & y coordinates and titles remain.
proc clear_graf_data {} {
    .cGraf.c delete graf_data
}



proc graf1 {} {

    global graf_type

    set font -Adobe-helvetica-medium-r-*-120-*

    .cGraf.c delete graf_grid
    clear_graf_data


    #
    # x axis line and text
    #
    .cGraf.c create line 50 250 350 250 -width 2 -tag graf_grid
    
    for {set i 0} {$i <= 6} {incr i} {
	set x [expr {50 + ($i*50)}]
	.cGraf.c create line $x 250 $x 245 -width 2 -tag graf_grid
	.cGraf.c create text $x 254 -text [expr 10*$i] -anchor n \
		-font $font -tag graf_grid
    }


    #
    # y axis line and text
    #
    .cGraf.c create line 50 250 50 50 -width 2 -tag graf_grid

    for {set i 0} {$i <= 5} {incr i} {
	set y [expr {250 - ($i*40)}]
	.cGraf.c create line 50 $y 55 $y -width 2 -tag graf_grid
	.cGraf.c create text 46 $y -text [expr $i*20].0 -anchor e \
		-font $font -tag graf_grid
    }
    

    .cGraf.c create text 175 20 \
	    -text "1 Hour Network Utilization" \
	    -font -Adobe-helvetica-medium-r-*-140-* -fill brown \
	    -tag graf_grid

    .cGraf.c create text 175 275 \
	    -text "Minutes" \
	    -font -Adobe-helvetica-medium-r-*-140-* -fill brown \
	    -tag graf_grid

    #
    # Plot the data
    #
    set graf_type 1
    graf_it
}





proc graf5 {} {

    global graf_type

    set font -Adobe-helvetica-medium-r-*-120-*

    .cGraf.c delete graf_grid
    clear_graf_data

    #
    # x axis line and text
    #
    .cGraf.c create line 50 250 350 250 -width 2 -fill brown \
	    -tag graf_grid
    
    for {set i 0} {$i <= 5} {incr i} {
	set x [expr {50 + ($i*60)}]
	.cGraf.c create line $x 250 $x 245 -width 2 -fill brown \
		-tag graf_grid

	.cGraf.c create text $x 254 -text [expr 1*$i] -anchor n \
		-fill brown \
		-font $font -tag graf_grid
    }


    #
    # y axis line and text
    #
    .cGraf.c create line 50 250 50 50 -width 2 -fill brown -tag graf_grid

    for {set i 0} {$i <= 5} {incr i} {
	set y [expr {250 - ($i*40)}]
	.cGraf.c create line 50 $y 55 $y -width 2 -fill brown \
		-tag graf_grid

	.cGraf.c create text 46 $y \
		-text [expr $i*20].0 -anchor e -fill brown \
		-font $font -tag graf_grid
    }
    

    .cGraf.c create text 175 20 \
	    -text "5 Hour Network Utilization" \
	    -font -Adobe-helvetica-medium-r-*-140-* \
	    -fill black -tag graf_grid

    .cGraf.c create text 175 275 \
	    -text "Hours" \
	    -font -Adobe-helvetica-medium-r-*-140-* \
	    -fill black -tag graf_grid

    #
    # Plot the data
    #
    set graf_type 5
    graf_it
}



proc graf25 {} {

    global graf_type

    set font -Adobe-helvetica-medium-r-*-120-*

    .cGraf.c delete graf_grid
    clear_graf_data

    #
    # x axis line and text
    #
    .cGraf.c create line 50 250 350 250 -width 2 -fill brown -tag graf_grid
    
    for {set i 0} {$i <= 5} {incr i} {
	set x [expr {50 + ($i*60)}]
	.cGraf.c create line $x 250 $x 245 -width 2 \
		-fill brown -tag graf_grid

	.cGraf.c create text $x 254 -text [expr 5*$i] -anchor n \
		-fill brown -font $font -tag graf_grid
    }


    #
    # y axis line and text
    #
    .cGraf.c create line 50 250 50 50 -width 2 -fill brown -tag graf_grid

    for {set i 0} {$i <= 5} {incr i} {
	set y [expr {250 - ($i*40)}]
	.cGraf.c create line 50 $y 55 $y -width 2 \
		-fill brown -tag graf_grid

	.cGraf.c create text 46 $y \
		-text [expr $i*20].0 -anchor e \
		-fill brown -font $font -tag graf_grid
    }
    

    .cGraf.c create text 175 20 \
	    -text "25 Hour Network Utilization" \
	    -font -Adobe-helvetica-medium-r-*-140-* \
	    -fill blue -tag graf_grid

    .cGraf.c create text 175 275 \
	    -text "Hours" -font -Adobe-helvetica-medium-r-*-140-* \
	    -fill blue -tag graf_grid

    #
    # Plot the data
    #
    set graf_type 25
    graf_it
}



proc graf_it { } {

    global graf_data \
	    graf_indx \
	    graf_type \
	    xNet_stopped \
	    rbaud

    # If XNET stopped, "retrun", nothing to plot
    if {$xNet_stopped} {return}


    # graf type (1, 5, 25 determines coordinate and key variables)
    switch $graf_type {
	1  { set graf_pts 60; set graf_pts_inc 5; set graf_color brown}
	5  { set graf_pts 300; set graf_pts_inc 1; set graf_color black}
	25 { set graf_pts 1500; set graf_pts_inc 0.2; set graf_color blue}
    }


    # compute utilization factor for graph based on radio baud, \
	    set packet overhead to accomdate efficiency if necessary \
	    current set at 1 (i.e., no alteration). \
	    This is a factor may be implemented in the future
    set pac_overhead 1
    set graf_ufac [expr 60 * $pac_overhead * $rbaud / 8]


    # Clear (delete) old graph and draw new graph everytime
    clear_graf_data


    # set plotting indexs, check for too few data points.
    if {$graf_indx > $graf_pts} {
	set wrt_indx [expr $graf_indx - $graf_pts -1]
	set end_indx $graf_indx

    } else {

	set wrt_indx 1
	set end_indx $graf_indx
    }


    for {set i 1} { ( $i <= $graf_pts) && ( $i <= $end_indx) } { incr i} {

	.cGraf.c create line \
		[expr 50 + $i * $graf_pts_inc] 250 \
		[expr 50 + $i * $graf_pts_inc] \
		[expr 250 - 250 * $graf_data($wrt_indx) / $graf_ufac] \
		-fill $graf_color -width 1 -tag graf_data

	incr wrt_indx
	if {$wrt_indx > 1500} { set wrt_indx 1 }
    }

}
