# install as ~/.tk/jeditrc.tcl - user customisation file for jedit
# * sets each window's icon to a miniature picture of the window and
#   its contents
# * explicitly positions each jedit window based on how many jedit
#   applications are running and how many windows this one has open
######################################################################

######################################################################
# additions to GUI:

proc jedit:userhook { window } {
  set t [jedit:top_to_text $window]	;# relevant text widget
  ######################################################################
  # window icon:
  
  if {[winfo class $window] == "Toplevel"} {
    catch {
      global jed_windows
      
      if ![info exists jed_windows] {
        set jed_windows 0
      } else {
        incr jed_windows
      }
      
      wm withdraw $window
      
      update idletasks
      
      # main window geometry (but this is really the window manager's job!)
      #
      set numjedits 0
      foreach interp [winfo interps] {
        if [string match {jedit*} $interp] {incr numjedits}
      }
      
      set xoffset [expr {( $numjedits * 60 ) + ( $jed_windows * 50 ) }]
      set yoffset [expr {( $numjedits * 35 ) + ( $jed_windows * 25 ) }]
      
      wm geometry $window +$xoffset+$yoffset
    }
    update
    
    wm deiconify $window
  }
}
