# install as ~/.tk/jeditrc.tcl - user customisation file for jedit
#   creates a User menu and adds some example commands to it.
#   (Doesn't use the jstools command mechanism, but ought to.)
######################################################################

######################################################################
# additions to GUI:

proc jedit:mkmenu:user {menu t} {
  $t tag configure hilight -background gold
  $t tag raise hilight				;# ????
  
  j:menu:menubutton $menu $menu.m JEmenu:user
  
  $menu.m add command \
    -label {Hilight} \
    -command "
      $t tag add hilight sel.first sel.last
    "
  $menu.m add command \
    -label {Unhilight} \
    -command "
      $t tag remove hilight sel.first sel.last
    "
  $menu.m add command \
    -label {Clear All Hilights} \
    -command "
      $t tag remove hilight 1.0 end
    "
  $menu.m add separator
  $menu.m add command \
    -label {Check Spelling} \
    -underline 0 \
    -command "
      j:more \
        -widgh 30 \
        -text \[exec ispell -l << \[$t get 0.0 end\] | sort | uniq\]
    "
  $menu.m add separator
  $menu.m add command \
    -label {Gold on Red} \
    -underline 0 \
    -command "
      jedit:format:background $t red
      jedit:format:foreground $t gold
      $t tag remove sel 1.0 end
      jedit:format:background:clear $t
      jedit:format:foreground:clear $t
    "
  $menu.m add command \
    -label {Plain Colours} \
    -underline 0 \
    -command "
      jedit:format:background:clear $t
      jedit:format:foreground:clear $t
    "
  $menu.m add separator
  $menu.m add command \
    -label {Source...} \
    -underline 3 \
    -command {
      source [j:fs {} {File to source:}]
    }
  $menu.m add command \
    -label "C\346sar Cipher" \
    -command [format {
      jedit:pipe %s "tr \
        abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ \
        nopqrstuvwxyzabcdefghijklmNOPQRSTUVWXYZABCDEFGHIJKLM"
    } $t]
  $menu.m add command \
    -label {Insert Date} \
    -command [format {
      j:text:insert_string %s \
      [exec date | awk "\{print \$2\" \"\$3\", \"\$6\}"]
    } $t]
  $menu.m add command \
    -label {Insert Decimal Date} \
    -underline 7 \
    -command [format {
      j:text:insert_string %s \
      [exec date +%%Y.%%m.%%d]
    } $t]
  $menu.m add command \
    -label {Insert Colour Name} \
    -underline 14 \
    -command [format {
      j:text:insert_string %s \
      [j:prompt_colour_name]
    } $t]
  $menu.m add command \
    -label {Insert Colour RGB} \
    -underline 14 \
    -command [format {
      j:text:insert_string %s \
      [j:prompt_colour_rgb]
    } $t]
  $menu.m add command \
    -label {Insert Font Name} \
    -underline 7 \
    -command [format {
      j:text:insert_string %s \
      [j:prompt_font]
    } $t]
  $menu.m add separator
  $menu.m add command \
    -label {New xterm} \
    -command {
      exec xterm &
    }
  $menu.m add command \
    -label {New jbrowser} \
    -command {
      exec jbrowser &
    }
}
