# jviewers.tcl - view URLs and man pages
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# j:view_url url - view a URL with the user's preferred browser
#   this is what applications should call
######################################################################

proc j:view_url { url } {
  global J_PREFS
  j:default J_PREFS(web_browser) mosaic
  
  j:view_url:$J_PREFS(web_browser) $url
}

######################################################################
# j:view_url:mosaic url - view a URL with Mosaic
######################################################################

proc j:view_url:mosaic { url } {
  exec Mosaic $url &
}

######################################################################
# j:view_url:netscape url - view a URL with Netscape
######################################################################

# borrowed from EXMH; credits:
# martin hamilton <martin@mrrl.lut.ac.uk>
# &
# John Robert LoVerso <loverso@osf.org>
# Toivo Pedaste <toivo@ucs.uwa.edu.au>
# Fred Douglis <douglis@research.att.com>

proc j:view_url:netscape { url } {
  if [ catch { exec netscape -remote openURL($url) } tmp ] {
    if { [ string first "not running on" $tmp ] != -1 } {
      exec netscape $url &
    }
  }
}
######################################################################
# j:view_url:arena url - view a URL with arena
######################################################################

# piping into jmore is a kludge to allow us to display the text that
# arena wants to print to standard out when it quits.

proc j:view_url:arena { url } {
  exec arena $url |& jmore &
}

######################################################################
# j:view_url:lynx url - view a URL with lynx in an xterm
######################################################################

proc j:view_url:lynx { url } {
  exec xterm -e lynx $url &
}

######################################################################
# j:view_man manpage - view a man page with the user's preferred browser
#   this is what applications should call
######################################################################

proc j:view_man { manpage } {
  global J_PREFS
  j:default J_PREFS(man_viewer) builtin
  
  j:view_man:$J_PREFS(man_viewer) $manpage
}

######################################################################
# j:view_man:builtin manpage -
#   view man page by postprocessing man(1) output
######################################################################

proc j:view_man:builtin { manpage } {
  catch {exec man $manpage |& ul -i} mantext
  j:more -height 30 \
    -title "Manual page for `$manpage'" \
    -text $mantext
}

######################################################################
# j:view_man:tkman manpage - tell tkman to show us manpage
#   taken from contrib/remote.tcl in TkMan 1.7.3 distribution
######################################################################

proc j:view_man:tkman { manpage } {
  if {[set found [lsearch [winfo interps] tkman*]]==-1} {
    # if TkMan doesn't already exist, start one up
    if {[catch {exec tkman &}]} {
      j:alert -text viewer:missing_tkman
      return
    }
    
    # wait for it to be registered
    for {set found -1} {$found==-1} {after 200} {
      set found [lsearch [winfo interps] tkman*]
    }
    
    # wait for it to initialize
    for {set ready 0} {!$ready} {after 200} {
      catch {if {[send tkman set manx(init)]=="1"} {set ready 1}}
    }
  }
  set tkman [lindex [winfo interps] $found]
  
  # .man is the main window, guaranteed to exist
  set w .man
  send $tkman raise $w
  send $tkman wm deiconify $w
  send $tkman manShowMan $manpage

  return
}

######################################################################
# j:view_man:man manpage - view man page in an xterm
######################################################################

proc j:view_man:man { manpage } {
  exec xterm -e man $manpage &
}





