# jlistlib.tcl - procedures for manipulating lists and paths
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# j:path:ancestor generation list - return generation'th ancestor of list
#   ([j:path:ancestor 0] is list itself; [j:path:ancestor 1] is parent)
######################################################################

proc j:path:ancestor { generation path } {
  if {$generation <= 0} {
    return $path
  }
  if {$generation == 1} {
    return [file dirname $path]
  }
  return [file dirname [j:path:ancestor [expr $generation - 1] $path]]
}


