# ~/.tk/edittkmodes/html-mode.tcl - mode for editing html
######################################################################

j:ldb:set_defaults {
  {menu:html {HTML} 1}
  {mode:html:mkx_email {Insert Email Reference...} 11}
  {mode:html:mkx_url {Make URL Reference...} 5}
  {mode:html:tag_img {Insert Graphic...} 7}
  
  {mode:html:mk_h1 {Make Level 1 Header} 11}
  {mode:html:mk_h2 {Make Level 2 Header} 11}
  {mode:html:mk_h3 {Make Level 3 Header} 11}
  {mode:html:mk_h4 {Make Level 4 Header} 11}
  {mode:html:mk_h5 {Make Level 5 Header} 11}
  {mode:html:mk_h6 {Make Level 6 Header} 11}
  {mode:html:mk_samp {Make Sample Text} 5}
  {mode:html:mk_code {Make Code} 7}
  {mode:html:mk_var {Make Variable} 5}
  {mode:html:mk_cite {Make Citation} 5}
  {mode:html:mk_em {Make Emphasised} 5}
  {mode:html:mk_strong {Make Strong} 10}
  {mode:html:mk_i {Make Italic} 5}
  {mode:html:mk_b {Make Bold} 5}
  {mode:html:mk_tt {Make Typewriter Text} 6}

  {mode:html:mk_ul {Make Unordered List} 6}
  {mode:html:mk_ol {Make Ordered List} 5}
  {mode:html:tag_li {List Item} 8}

  {mode:html:tag_p {Paragraph Break} 0}
  {mode:html:tag_hr {Horizontal Rule} 0}
  {mode:html:tag_br {Line Break} 9}
  
  {mode:html:insert_selection {Insert Preformatted Selection} 10}
  
  {mode:html:template {HTML Document Template} 14}
  
  {{Email Address} {Email Address}}
  {{Email Address:} {Email Address:}}
  {{URL} {URL}}
  {{URL:} {URL:}}
  {{Alternate Text} {Alternate Text}}
  {{Alternate Text:} {Alternate Text:}}
  
  {{Help on html Mode} {Help on `html' Mode}}
}

proc mode:html:init { t } {
  global JEDIT_MODEPREFS
  
  j:read_prefs -array JEDIT_MODEPREFS -prefix html \
    -directory ~/.tk/jeditmodes -file html-defaults {
    {textfont default}
    {textwidth 80}
    {textheight 24}
    {textwrap word}
    {sabbrev 0}
    {dabbrev 0}
    {autobreak 1}
    {autoindent 1}
    {parenflash 0}
    {savestate 0}
    {buttonbar 1}
    {buttons {
      jedit:cmd:done
      jedit:cmd:save
      jedit:cmd:load
      jedit:cmd:print
    }}
    {docs {
      -
      {{Help on html Mode} {jeditmodes/html-mode.jdoc}}
    }}
    {menu,editor 1}
    {menu,file 1}
    {menu,edit 1}
    {menu,prefs 1}
    {menu,abbrev 1}
    {menu,filter 1}
    {menu,format 0}
    {menu,display 0}
    {menu,mode1 1}
    {menu,mode2 1}
    {menu,user 1}
  }
}

proc mode:html:mkmenu1 { menu t } {
  j:menu:menubutton $menu $menu.m menu:html
  
  j:menu:commands $menu.m $t {
    mode:html:mkx_url
    mode:html:mkx_email
    mode:html:tag_img
    -
    mode:html:mk_h1
    mode:html:mk_h2
    mode:html:mk_h3
    mode:html:mk_h4
    mode:html:mk_h5
    mode:html:mk_h6
    -
    mode:html:mk_samp
    mode:html:mk_code
    mode:html:mk_var
    mode:html:mk_cite
    mode:html:mk_em
    mode:html:mk_strong
    -
    mode:html:mk_i
    mode:html:mk_b
    mode:html:mk_tt
    -
    mode:html:mk_ul
    mode:html:mk_ol
    mode:html:tag_li
    -
    mode:html:tag_p
    mode:html:tag_br
    mode:html:tag_hr
    -
    mode:html:insert_selection
    -
    mode:html:template
  }
}

# wrap selected text in a pair of (possibly distinct) tags
#
proc mode:html:tag_wrap2 { t tag1 tag2 } {
  # set end to end of selection if any, else insert:
  set end [$t index insert]
  catch {set end [$t index sel.last]}
  
  # set start to beginning of selection if any, else insert:
  set start [$t index insert]
  catch {set start [$t index sel.first]}
  
  $t tag remove sel 1.0 end		;# otherwise may be overwritten
  
  # (order is important here, because insert changes):
  j:text:move $t $end
  j:text:insert_string $t "<$tag2>"
  j:text:move $t $start
  j:text:insert_string $t "<$tag1>"
}

# wrap selected text in a tag
#
proc mode:html:tag_wrap { t tag } {
  mode:html:tag_wrap2 $t $tag /$tag
}

proc mode:html:mkx_email { t } {
  set emailaddr [j:prompt -title "Email Address" -text "Email Address:"]
  j:text:insert_string $t {<samp><a href="mailto:}
  j:text:insert_string $t $emailaddr
  j:text:insert_string $t {">&lt;}
  j:text:insert_string $t $emailaddr
  j:text:insert_string $t {&gt;</a></samp>}
}

proc mode:html:mkx_url { t } {
  set url [j:prompt -file 1 -title "URL" -text "URL:"]
  mode:html:tag_wrap2 $t "a href=\"$url\"" "/a"
}

proc mode:html:tag_img { t } {
  set url [j:prompt -file 1 -title "URL" -text "URL:"]
  set alt [j:prompt -file 0 -title "Alternate Text" -text "Alternate Text:"]
  j:text:insert_string $t "<img src=\"$url\" alt=\"$alt\">"
}

proc mode:html:insert_selection { t } {
  j:text:insert_string $t "<pre>\n"
  set text ""
  catch {set text [selection get]}
  regsub -all -- {\&} $text {\&amp;} text
  regsub -all -- {<} $text {\&lt;} text
  regsub -all -- {>} $text {\&gt;} text
  j:text:insert_string $t $text
  j:text:insert_string $t "</pre>\n"
}

proc mode:html:tag_p { t } {
  $t tag remove sel 1.0 end		;# otherwise may be overwritten
  # using jedit:returnkey instead of just "\n" allows auto-indentation
  jedit:returnkey $t
  j:text:insert_string $t "<p>"
  jedit:returnkey $t
}

proc mode:html:tag_br { t } {
  $t tag remove sel 1.0 end		;# otherwise may be overwritten
  # using jedit:returnkey instead of just "\n" allows auto-indentation
  jedit:returnkey $t
  j:text:insert_string $t "<br>"
  jedit:returnkey $t
}

proc mode:html:tag_hr { t } {
  $t tag remove sel 1.0 end		;# otherwise may be overwritten
  # using jedit:returnkey instead of just "\n" allows auto-indentation
  jedit:returnkey $t
  j:text:insert_string $t "<hr>"
  jedit:returnkey $t
}

proc mode:html:template { t } {
  j:text:insert_string $t {<html>
<header>
<title>__TITLE__</title>
</header>
<body>
<h1>__TITLE_AGAIN__</h1>

BODY

<hr>
<address>
Last changed __DATE__ by __PERSON__
</address>
</body>
</html>
}
}

proc mode:html:mk_h1 { t } {
  mode:html:tag_wrap $t h1
}

proc mode:html:mk_h2 { t } {
  mode:html:tag_wrap $t h2
}

proc mode:html:mk_h3 { t } {
  mode:html:tag_wrap $t h3
}

proc mode:html:mk_h4 { t } {
  mode:html:tag_wrap $t h4
}

proc mode:html:mk_h5 { t } {
  mode:html:tag_wrap $t h5
}

proc mode:html:mk_h6 { t } {
  mode:html:tag_wrap $t h6
}

proc mode:html:mk_samp { t } {
  mode:html:tag_wrap $t samp
}

proc mode:html:mk_code { t } {
  mode:html:tag_wrap $t code
}

proc mode:html:mk_var { t } {
  mode:html:tag_wrap $t var
}

proc mode:html:mk_cite { t } {
  mode:html:tag_wrap $t cite
}

proc mode:html:mk_em { t } {
  mode:html:tag_wrap $t em
}

proc mode:html:mk_strong { t } {
  mode:html:tag_wrap $t strong
}

proc mode:html:mk_i { t } {
  mode:html:tag_wrap $t i
}

proc mode:html:mk_b { t } {
  mode:html:tag_wrap $t b
}

proc mode:html:mk_tt { t } {
  mode:html:tag_wrap $t tt
}

######################################################################

proc mode:html:mk_ul { t } {
  mode:html:tag_wrap $t ul
}

proc mode:html:mk_ol { t } {
  mode:html:tag_wrap $t ol
}

proc mode:html:tag_li { t } {
  $t tag remove sel 1.0 end		;# otherwise may be overwritten
  # using jedit:returnkey instead of just "\n" allows auto-indentation
  jedit:returnkey $t
  j:text:insert_string $t "<li>"
}


