#
# $Header: /home/rockware/cvs-main/operator/tcl/opDirIcons.tcl,v 1.27 1995/03/14 21:53:29 erez Exp $
# Written by: Erez Strauss (C) All Rights Reserved 1994, 1995.
#

itcl_class OpDirIcons {
    inherit OpDirDisplay
    constructor {directory config} {
        if $files_flag {set f {-f}} {set f {}}

        set tmp_menus "$tl_menus $dird_menus $di_menus"

        OpDirDisplay::constructor $directory \
            -menus $tmp_menus \
            -menu_bar $di_menubar \
            -iconbitmap tree \
            -pipe_cmd "[opNameToFile srtree prog] $f -d 0 ."

        set ws $work_space.i
        set canvas $ws.u.c
        frame $ws -relief flat
        ::pack $ws -expand on -fill both
        OpSCanvas :: create $ws

        opActiveHelpBind $this "Directory Icons - $this"
        bind $canvas <Double-1> "+$this canvas_select %x %y"
        OpSCanvas :: drag $ws 1

        ::update
        update
        ::update
    }
    destructor {
        OpDirDisplay::destructor
    }
    method config config {}

    method disp_start {} {
        $canvas delete all
    }
    method disp_entry entry {
        set base [file tail $entry]
    # the opNameToBitmapFile function calls to 'file isdirectory' that should have the absolute file name.
    # because we have no guarenty that we are at the same directory.
        set bmp_f [opNameToBitmapFile $dir/$entry file]
        if {$bmp_f != {}} {
            set id [$canvas create icon 0 0 -text $base -tag $entry -bord 1 -bitmap "@$bmp_f"]
        } {
            set id [$canvas create icon 0 0 -text $base -tag $entry -bord 1]
        }
        # $canvas bind $id <Double-1> {opFileActivate [opSelectionGet]}
    }
    method disp_end {} {
        # relocate all the icons.
        set lines [expr sqrt ([llength [$canvas find all]])]
        if {$lines > 0} {
            set col [expr [llength [$canvas find all]] / $lines]
            set r 0
            set c 0
            set x 0
            set y 0
            # puts "All :[$canvas find all]:"
            foreach i [$canvas find all] {
                $canvas itemconfig $i -x $x -y $y
                if {$c < $col} {
                    incr c
                    set b [$canvas bbox $i]
                    set x [expr [lindex $b 2] + 4]
                } {
                    set c 0
                    incr r
                    set b [$canvas bbox all]
                    set y [expr [lindex $b 3] + 4]
                    set x 0
                }
            }
        } {
            .fileEmptyDisplay on
        }
        OpSCanvas :: update $work_space.i
    }
    method canvas_select {x y} {
        set cur [$canvas find withtag current]
        if {[string match [$canvas type $cur] icon]} {
            set tag [lindex [lindex [$canvas itemconf $cur -tag] 4] 0]
            if [file isdirectory $dir/$tag] {
                if $open_new_win {
                    OpDirIcons :: open $dir/$tag
                } {
                    $this move_to_dir $dir/$tag
                }
            } {
                opFileActivate $dir/$tag
            }
        }
    }
    method canv {} {return $canvas}
    method what_label {} {return DirIcons}
    proc open d {
        set swd [pwd]
        if ![file isdirectory $d] {set d [file dirname $d]}
        cd $d
        set d [pwd]
        cd $swd
        if [::info exists dir2obj(OpDirIcons,$d)] {
            $dir2obj(OpDirIcons,$d) raise
        } {
            incr serial_number
            OpDirIcons .dir_icons$serial_number $d
        }
    }
    public files_flag 1 {
    }
    # regexp filer those that mach are displayed.
    #public regexp_in {} {if $after_constructor update}
    # regexp filer those that mach are >not< displayed.
    #public regexp_out {} {if $after_constructor update}

    protected canvas {}
    protected x 0
    protected y 0
    protected to_update 0
    protected colWidthPix 40
    # 5*8
    common serial_number 0
    common di_menus {
        {di_view {
            {checkbutton -label {Show Filter} -onvalue 1 -offvalue 0 -variable OPDirDisplay(THIS,filter) -command {global OPDirDisplay ; THIS config -disp_filter_flag $OPDirDisplay(THIS,filter)}}
            {checkbutton -label {Dir Entry} -onvalue 1 -offvalue 0 -variable OPDirDisplay(THIS,dir_disp) -command {global OPDirDisplay ; THIS config -disp_dir_flag $OPDirDisplay(THIS,dir_disp)}}
            {checkbutton -label {New Win} -onvalue 1 -offvalue 0 -variable OPDirDisplay(new_win) -command {global OPDirDisplay ; [THIS info class] :: set_new_win $OPDirDisplay(new_win)}}
            {command -label {Go Home} -under 0 -command {THIS move_to_dir [glob ~]}}
            {command -label {Move up} -under 0 -command {THIS move_to_dir [THIS what_dir]/..}}}
        }
    }
    common di_menubar {{File 0 dird_file} {Edit 0 dird_edit} {View 0 di_view} {Windows 0 tl_wins} {Help 0 tl_help right}}
}
