
defwidget Output

defmethod Output new {name args} {
  global color font

  args	{title Output} textfont {width 32} {height 6} \
	command {freq 60000} layout embedded showchanges

  if { $embedded == "true" } {
    Frame new $name
    Title new $name.title -text $title
    if { $layout == "" } {
      set layout top
    }
  } {
    Toplevel new ${name} -title $title
    if { $layout == "" } {
      set layout choose
    }
  }
  defsuper $name Output

  if { [Color pick mono color] == "color" && $showchanges == "true" } {
    $name slot _showchanges 1
  } {
    $name slot _showchanges 0
  }

  if { $textfont == {} } then {
    if { $command == {} } then {
      set textfont small
    } else {
      set textfont fixed
    }
  }

  if { $embedded != "true" } {
    Button new $name.quit -layout {bottom pady 30} \
	-text "Dismiss" -action "$name Dismiss" -textfont large
  }

  Text new $name.t \
	-textfont $textfont \
	-width $width -height $height \
	-layout {bottom padx 30}

  if { [$name slot _showchanges] } {
    $name.t tag configure change \
	-relief raised \
	-foreground [Color slot fg,alert] \
	-background [Color slot bg,alert]
  }

  Label new $name.l -layout {left padx 30} -relief flat -fit true

  $name update $command $freq

  $name layout $layout
}

defmethod Output update {command freq} {

  $self redisplay [app(getoutput) $command]
  if { $freq != {} } {
    after $freq [list catch [list $self update $command $freq]]
  }
}

defmethod Output redisplay {text} {

  set width 32
  foreach line $text {
    set l [string length $line]
    if { $width < $l } then {
      set width $l
    }
  }
  set height [llength $text]

  set showchanges [$self slot _showchanges]
  set oldtext [$self slot _text]
  set changes {}
  if { $oldtext != {} } {
    set lcount 1
    foreach line $text {
      set mark 1
      foreach oldline $oldtext {
	if { $line == $oldline } {
	  set mark 0
	  break
	}
      }
      if { $mark } {
	lappend changes $lcount
      }
      incr lcount
    }
  }

  if { $height < 3 } then {
    set height 3
  }

  $self.l set [date]
  $self.t! configure -width [expr $width+3] -height $height
  $self.t set [join $text "\n"]

  if { $showchanges } {
    foreach mark $changes {
      $self.t! tag add change $mark.0 $mark.0lineend
    }
    $self slot _text $text
  }

  return $self
}

Window addDemo Output

defmethod Output demo {} {

  Output new * -command "w" -width 80 -freq 2000 -showchanges true \
	-layout center
}
