/* 
 * vogle_local.c 
 */
#include "vogle.h"
#include <stdio.h>
#include <assert.h>



/*
 * pick buffer related data structures
 */
typedef struct {
    int *buf;
    int current;
    int size;
} pickbuf;

static pickbuf *GlobalPickBuf = NULL;

#define SET_PICK_ID(p,i) \
    (p)->current = (((p)->current < (p)->size) ? ((p)->current+1) : 0), \
    (p)->buf[(p)->current] = i

#define PICKBUF_CHECK(p) \
    assert((p) &&\
	(p)->buf &&\
	(p)->current>=-1 &&\
	(p)->current<(p)->size &&\
	(p)->size>0)
/*
 * pickbuffer functions
 */
pickbuf *
newpickbuf(size)
{
    pickbuf *p = (pickbuf *)malloc(sizeof(pickbuf));
    if (!p) {
	return p;
    }
    if ((size < 1) || !(p->buf = (int *)malloc(sizeof(int)*size))) {
	free(p);
	return (pickbuf *)NULL;
    }
    p->size = size;
    clearpickbuffer(p);
    return p;
}

destroypickbuf(p)
pickbuf *p;
{
    PICKBUF_CHECK(p);

#ifndef NDEBUG
    /* invalidate pickbuffer */
    p->buf = NULL; 
    p->current = p->size = -100;
#endif
    free(p->buf);
    free(p);
    return 0;
}

/* 
 * pickbuf parameters are unused right now. they are there if we
 * decide to have multiple pick buffers later 
 */
clearpickbuffer(p)
pickbuf *p;
{
    PICKBUF_CHECK(p);
    p->current = -1;
    return 0;
}

int
setpickid(p, id)
pickbuf *p;
int id;
{
    if (!p) {
	if (!GlobalPickBuf && (!(GlobalPickBuf = newpickbuf(100)))) {
	    return -1;
	}
    } else {
	PICKBUF_CHECK(p);
    }
    if (vdevice.inobject) {
	Token *t;
	if (!(t = newtokens(2))) {
	    return -1;
	}
	t[0].i=PICKID;
	t[1].i=id;
    } else {
	SET_PICK_ID(p, id);
    }
    return 0;
}

Token *
callobj_local(tp)
Token *tp;
{
    switch(tp->i) {
    case PICKID:
	setpickid(GlobalPickBuf, tp[1].i);
	return tp+2;
    default:
	return (Token *)0;
    }
}
