'\"
'\" Copyright 1990 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /cluster21/kennykb/src/tclTCP.1.0beta/RCS/simpleEvent.man,v 1.2 1992/05/05 18:30:16 kennykb Exp $ SPRITE (Berkeley)
'\" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'	# BS - start boxed text
'	# ^y = starting y location
'	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'	# VS - start vertical sidebar
'	# ^Y = starting y location
'	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'	# Special macro to handle page bottom:  finish off current
'	# box/sidebar if in box/sidebar mode, then invoked standard
'	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'	# DS - begin display
.de DS
.RS
.nf
.sp
..
'	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS "Simple\ Event\ Manager" lib
.BS
.SH NAME
\fBsimpleEvent\fR \- Simple event manager for Tcl applications
.SH SYNOPSIS
.nf
\fB#include <simpleEvent.h>\fR
.sp
\fBsimpleCreateFileHandler\fR(\fIfd, mask, fproc, clientData\fR)
.sp
\fBsimpleDeleteFileHandler\fR(\fIfd\fR)
.sp
\fBsimpleDoWhenIdle\fR(\fIiproc, clientData\fR)
.sp
\fBsimpleCancelIdleCall\fR(\fIiproc, clientData\fR)
.sp
\fBsimpleReportBackgroundError\fR(\fIinterp\fR)
.sp
\fBsimpleSetAppContext \fR(\fIappContext\fR)
.sp
\fBsimpleSelect\fR(\fIselectFlags\fR)
.SH ARGUMENTS
.AS Simple_FileProc selectFlags in
.AP XtAppContext appContext in
Application context to be used within programs that use the Xt toolkit.
.AP ClientData clientData in
Arbitrary one-word value to pass to \fIfproc\fR or \fIiproc\fR.
.AP int fd in
Integer identifier for an open file, socket, or device (such as
returned by the \fBopen\fR system call).
.AP Simple_FileProc *fproc in
Procedure to invoke when the file, socket, or device specified by
\fIfd\fR meets the conditions specified by \fImask\fR.
.AP Tcl_Interp *interp in
Interpreter that has detected an error.
.AP Simple_IdleProc *iproc in
Procedure to invoke when no events are pending for the system.
.AP int mask in
Conditions under which \fIfproc\fR should be called: OR-ed combination
of \fBSIMPLE_READABLE\fR, \fBSIMPLE_WRITABLE\fR, and
\fBSIMPLE_EXCEPTION\fR.
.AP int selectFlags in
Flags governing what simpleSelect should do: OR-ed combination of
\fBSIMPLE_DO_EVENTS\fR and \fBSIMPLE_WAIT\fR.
.BE

.PP
Copyright (C) 1992 General Electric. All rights reserved.

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of General Electric not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
General Electric makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.
.sp
This work was supported by the DARPA Initiative in Concurrent
Engineering (DICE) through DARPA Contract MDA972-88-C-0047.

.SH OVERVIEW
.PP
The \fBsimpleEvent\fR library provides the C programmer with a single
means to handle file and idle events, regardless of the event
management that is linked with an application.  It can run correctly
with the event handlers used by Tk or Xt, or it can be used
stand-alone.  The particular version of the library is selected by
including one of the linker flags \fB-lsimpleEvent\fR,
\fB-lsimpleEvent_Tk\fR, or \fB-lsimpleEvent_Xt\fR.

The library is designed to be used with applications that use Tcl(3)
as a command processor.  For this reason, a procedure called
\fBsimpleReportBackgroundError\fR is provided to report errors that
occurred in the background\(emthat is, in response to an asynchronous
event originating in the \fBsimpleEvent\fR library.  It is possible
for a non-Tcl-based application to use the simpleEvent library if it
provides some other means of reporting background errors.

.SH "IDLE CALLS"
.PP
The \fBsimpleDoWhenIdle\fR function arranges for \fIiproc\fR to be invoked
when the application becomes idle.  The application is
considered to be idle when all currently-pending events have been
processed, and before waiting for new events to arrive.
.PP
The \fIiproc\fP function should have arguments and result that match the
type \fBSimple_IdleProc\fR:
.DS
typedef void Simple_IdleProc(ClientData \fIclientData\fR);
.DE

When the application becomes idle, \fIiproc\fR is invoked.  Upon
return from \fIiproc\fR, the handler is removed from the idle list.
.PP
The \fIclientData\fP parameter to \fIiproc\fR is a copy of the \fIclientData\fP
argument given to \fBSimple_DoWhenIdle\fR.  Typically, \fIclientData\fR
points to a data structure containing application-specific information about
what \fIiproc\fR should do.
.PP
The \fBsimpleCancelIdleCall\fR function
may be used to cancel one or more previous
calls to \fBsimpleDoWhenIdle\fR:  if there is a \fBsimpleDoWhenIdle\fR
handler registered for \fIiproc\fR and \fIclientData\fR, then it
is removed without invoking it.  If there is more than one
handler on the idle list that refers to \fIiproc\fR and \fIclientData\fR,
all of the handlers are removed.  If no existing handlers match
\fIproc\fR and \fIclientData\fR then nothing happens.
.PP
The \fBsimpleDoWhenIdle\fR function is most useful in situations where
something has to be done that cannot be done at the present time.
For example, a procedure handling an interprocess communication may 
need to start another communication to the same remote process,
after all status has been reported on the current operation.  It can
do so by establishing a \fBsimpleDoWhenIdle\fR handler that starts the
communication when it is invoked.

.SH "FILE HANDLERS"

The \fBsimpleCreateFileHandler\fR function arranges for \fIfproc\fR to
be invoked in the future when a specified condition is present on the
file identified by the file descriptor \fIfd\fR.  The condition under
which \fIfproc\fR should be invoked is identified by the argument \fImask\fR.
For example, if \fImask\fR is \fBSIMPLE_READABLE | SIMPLE_EXCEPTION\fR,
then \fIfproc\fR should be invoked whenever the file is readable or an
exceptional condition exists for the file.

The \fIfproc\fR procedure should have arguments and result that match
the type Simple_FileProc:
.DS
typedef void Simple_FileProc(ClientData \fIclientData\fR, int \fImask\fR);
.DE

The \fIclientData\fR parameter passed to \fIfproc\fR is a copy of the
\fIclientData\fR parameter that was passed to simpleCreateFileHandler
when the handler was created.  Typically, \fIclientData\fR is a
pointer to an application-specific structure that describes the file.
The \fImask\fR parameter passed to \fIfproc\fR is an integer mask
indicating which of the requested conditions actually exists for the
file.

There will be only one file handler for a given file at any time.  If
\fBsimpleCreateFileHandler\fR is called a second time for the same
file, the second handler will supersede the first.

The \fBsimpleDeleteFileHandler\fR function may be called to delete a
file handler established by \fBsimpleCreateFileHandler\fR.  The
\fIfd\fR parameter identifies the file whose handler is no longer
required.  If no handler exists for the file identified by \fIfd\fR,
the \fBsimpleDeleteFileHandler\fR function does nothing.

.SH "BACKGROUND ERRORS"

The \fBsimpleReportBackgroundError\fR function is provided for
reporting errors that originate in the callbacks provided by
\fBsimpleCreateFileHandler\fR and \fBsimpleDoWhenIdle\fR.  It allows
the application to handle
Tcl errors that occur while processing asynchronous events.

The problem requiring \fBsimpleReportBackgroundError\fR is that Tcl
commands invoked by a \fBTcl_Eval\fR in a callback procedure do not
originate directly from an application, and so there is no obvious way
to report errors in processing them.

\fBsimpleReportBackgroundError\fR invokes a Tcl command
named \fBbgerror\fR, passing it the error message (obtained from the
\fIinterp\fR parameter) as its only argument.  It assumes that the
application has implemented the \fBbgerror\fR command, and that the
\fBbgerror\fR command will report the error in a way that makes sense
for the application.

If another Tcl error occurs within the \fBbgerror\fR command (for
example, if the user hasn't defined a \fBbgerror\fR command), the
\fBsimpleReportBackgroundError\fR function attempts to print both the
original error and the error in \fBbgerror\fR in a message to
\fIstderr\fR.  If this print request fails, the
\fBsimpleReportBackgroundError\fR function gives up and dumps core
using the \fBabort\fR library function.

.SH "Xt APPLICATION CONTEXT"

In an application that uses the Xt main event loop, it is possible for
events to be handled in multiple application contexts.  If an
application requires this level of sophistication, but still wants to
use this event handler as well, the application context for the simple
event manager has to be established.  To do so, the application calls
\fBsimpleSetAppContext\fR, passing it the desired application context.
The \fBsimpleSetAppContext\fR procedure should generally be called
only once, at initialization time.

.SH "SELECT"

The \fBsimpleSelect\fR procedure makes it possible for applications to
use their own event loops.  Normally, the \fBsimpleEvent\fR procedures
use the main event loop contained within one of the X window toolkits,
Tk or Xt.  If an application is not using either toolkit, it can still
use the event manager by having its own main event loop.

The event loop should call \fBsimpleSelect\fR periodically to process
pending events.  The \fIselectFlags\fR parameter specifies what do do
with pending events.  If the \fBSIMPLE_DO_EVENTS\fR bit is set, the
callbacks are executed; if it is not set, the events are not
processed.  If the \fBSIMPLE_WAIT\fR bit is set, the event manager
waits if no events are pending; if it is not set, the process does not
wait.

In any case, \fBsimpleSelect\fR returns a count of events processed.
If it returns a negative value, this indicates that an error occurred
in processing the events.  The system variable \fIerrno\fR describes
the error.  If \fIerrno\fR is non-zero, it contains a Unix error code
describing the problem.  If \fIerrno\fR is zero, it indicates that the
application called \fBsimpleSelect\fR when no file or idle handlers
were defined, and the application would wait indefinitely if an error
were not reported.

A sample event loop for an application is:

.DS
/* Run the application */

do {
	status = simpleSelect (SIMPLE_WAIT | SIMPLE_DO_EVENTS);
} while (status >= 0);

/* Print a message if the main loop got an error

if (errno != 0) {
	perrno ("main loop");
}
.DE

.SH "SEE ALSO"
Tcl(3), bgerror(1)
