'\"
'\" Copyright 1993 D.I.S. \- Universita` di Pavia \- Italy
'\"
'\" Permission to  use,  copy,   modify,   distribute  this  software
'\" and  its  documentation for any purpose is hereby granted without
'\" fee, provided that the above copyright  notice   appear   in  all
'\" copies   and  that both that copyright notice and this permission
'\" notice appear in supporting documentation, and that the  name  of
'\" D.I.S.   not  be  used  in advertising or publicity pertaining to
'\" distribution of the software without specific, written prior per\-
'\" mission.   D.I.S.  makes no representations about the suitability
'\" of this software for any purpose.  It is provided "as is" without
'\" express or implied warranty.
'\"
'\" D.I.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, IN\-
'\" CLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
'\" NO EVENT SHALL D.I.S.  BE LIABLE FOR  ANY  SPECIAL,  INDIRECT  OR
'\" CONSEQUENTIAL  DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING FROM
'\" LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
'\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNEC\-
'\" TION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
'\"
.TH dtcl 1 "26 June 1993" "Shells"
.SH "NAME"
.LP
dtcl \- basic TCL shell with dynamic extension loading
.SH "SYNOPSIS"
.LP
\fBdtcl\fP [\fB\-H\fP] [\fB\-e\fP \fIcommand\fP]
[\fB\-f\fP \fIsourceFile\fP] [\fIargs\fP .\|.\|.]
.SH "OPTIONS"
.LP
.IP "\fB\-H\fP"
Print a summary of the command\-line options and exit.
.IP "\fB\-f\fP \fIsourceFile\fP"
Execute commands from \fIsourceFile\fP and exit.
.IP "\fB\-e\fP \fIcommand\fP"
Execute \fIcommand\fP and exit.
.SH "DESCRIPTION"
.LP
\fBDtcl\fP is a simple program consisting of the Tcl command
language and a main program that reads commands from standard input
or from a file.  If neither the \fB\-f\fP option nor the \fB\-e\fP
option is specified when invoking \fBdtcl\fP, it enters
a user\-command loop. It will continue prompting the user for commands
and printing back results until end\-of\-file is reached on standard input
or it is given the \fIexit\fP command.  
.LP
During interactive operations the user can inhibit printing of return
values by terminating commands with a semicolon and execute external
commands escaping them with an exclamation mark.
.LP
If the \fB\-f\fP option is specified or something is redirected
to its standard input, then \fBdtcl\fP reads Tcl commands from the
file named in the \fB\-f\fP option or from \fIstdin\fP. When
end\-of\-file is reached, \fBdtcl\fP will exit.
.LP
If the \fB\-e\fP option is specified \fBdtcl\fP will execute the
given \fIcommand\fP, terminating as soon as it is completed. 
.LP
The name with which \fBdtcl\fP was invoked and additional arguments are
stored as a list in the Tcl global variable \fIargv\fP. The length of this
list is stored in the Tcl global variable \fIargc\fP.
.LP
In addition to those already provided by the Tcl library
the \fBdwish\fP program defines the \fBload\fP command to supports loading
of extension libraries at run\-time.
.SH "SEE ALSO"
.LP
\fBdwish\fP(1), \fBload\fP(3)
