global dccInfo
set dccInfo {}

proc makeDCCChannel {name} {
    set rname $name
    set name ~[set lrname [string tolower $name]]
    global HPos ; set HPos($name) 0
    global HBuff ; set HBuff($name) {}
    global popUp ; global Open ; set Open($name) $popUp
    global popDown ; global Close ; set Close($name) $popDown
    global noJump ; global Jump ; set Jump($name) $noJump
    global quiet ; global Quiet ; set Quiet($name) $quiet
    foreach auto [getAuto $name] {
	case $auto {
	open { set Open(${name}) 1 }
	close { set Close($name) 1 }
	nojump { set Jump($name) 1 }
    	quiet { set Quiet($name) 1 }
	}
    }
    global Active ; set Active($name) 0
    global History ;
    if {[set History($name) [getHistory $name]] == {} } {
	global history ; set History($name) $history
    }
    if {[winfo exists .$name]} {return}
    set win .$name
    toplevel $win -class Zircon
    wm title $win "DCC Chat with $rname"
    wm minsize $win 40 1
    setIcon $win $name "Chat $rname"

    set oFrm $win.oFrm
    frame $oFrm -relief raised
    frame $oFrm.cmds -borderwidth 0
    set of [frame $oFrm.cmds.cmds0]
    set om [makeMB $of.mode Mode]
    zpack $of mode {left expand fillx}
    $om add checkbutton -label {Pop Up} -variable Open($name)
    $om add checkbutton -label {Pop Down} -variable Close($name)
    $om add checkbutton -label {No Jump} -variable Jump($name)
    $om add checkbutton -label Quiet -variable Quiet($name)
    set om [makeMB $of.channel User]
    $om add command -command "sendIRC WHOIS ${lrname}" -label Whois
    $om add command  -command "channelNotice ${lrname}" -label Notice
    addCTCPMenu $om $lrname
    addDCCMenu $om $lrname
    $om add cascade -label Log -menu $om.log
    menu $om.log
    foreach cmd {Close Open Flush Empty} {
	$om.log add command -label $cmd -command "doLog ${name} $cmd" \
	  -state disabled
    }
    menubutton $of.action -text Action -state disabled
    frame $oFrm.cmds.cmds1
    button $oFrm.cmds.cmds1.quit -command "leaveDCC $lrname" -text Leave
    button $oFrm.cmds.cmds1.clear -command "clearChannel $name" -text Clear
    zpack $of {mode channel action} {left expand fillx} 

    tk_menuBar $of $of.mode $of.channel $of.action
    zpack $oFrm.cmds.cmds1 {quit clear} {left expand fillx}
    zpack $oFrm.cmds {cmds0 cmds1} {left expand fillx}

    set om [frame $oFrm.cmdLine -relief raised]
    scrollbar $om.cscroller -orient horizontal -command "$om.commandLine view"
    emacsEntry $om.commandLine -scrollcommand "$om.cscroller set"
    zpack $om {commandLine cscroller} {expand fillx}

    set oft [frame $oFrm.textFrm -relief raised]
    scrollbar $oft.vscroller -command "$oft.text yview"
    set ot $oft.text
    text $ot -yscrollcommand "$oft.vscroller set"
    rebind $ot
    global BF
    global Fg
    global Bg
    global Ft
    set BF($name) [getOValue $ot font boldFont Font]
    set Ft($name) [getOValue $ot font font Font]
    set Fg($name) [getOValue $ot foreground foreground Foreground]
    set Bg($name) [getOValue $ot background background Background]
    $oft.text conf -selectforeground $Bg($name) -selectbackground $Fg($name)
    zpack $oft text {left expand fill}
    zpack $oft vscroller {left filly} 
    zpack $oFrm cmds {fillx}
    zpack $oFrm textFrm {expand fill}
    zpack $oFrm cmdLine {fillx} 

    pack append $win $oFrm {left expand fill}

    set occ $oFrm.cmdLine.commandLine
    set occ $oFrm.cmdLine.commandLine
    bind $occ <Meta-s> "
	global Active ; set Active($name) 2
	global smiley ; %W insert insert \$smiley
	tk_entrySeeCaret %W
    "
    bind $occ <Shift-Meta-S> "
	global Active ; set Active($name) 2
	global scowl ; %W insert insert \$scowl
	tk_entrySeeCaret %W
    "
    bind $occ <Control-Meta-s> "
	global Active ; set Active($name) 2
	global wink ; %W insert insert \$wink
	tk_entrySeeCaret %W
    "
    bind $occ <Meta-j> {
	if {![catch {selection get} bf ] && $bf != {}} { channelJoin $bf }
    }
    bind $occ <Meta-m> {
	if {![catch {selection get} bf] && $bf != {}} {
	    makeChannel [string range $bf 0 8] M
	}
    }
    bind $occ <Any-KeyPress> "
	global Active ; set Active($name) 2
	if {\"%A\" != {}} { %W insert insert %A ; tk_entrySeeCaret %W }
    "
    bind $occ <Delete> "
	global Active ; set Active($name) 2
	tk_entryBackspace %W; tk_entrySeeCaret %W
    "
    bind $occ <BackSpace> "
	global Active ; set Active($name) 2
	tk_entryBackspace %W; tk_entrySeeCaret %W
    "
    bind $occ <Control-h> "
	global Active ; set Active($name) 2
	tk_entryBackspace %W; tk_entrySeeCaret %W
    "
    bind $occ <Control-d> "
	global Active ; set Active($name) 2
	%W delete insert
    "
    bind $occ <Control-u> "
	global Active ; set Active($name) 2 ; %W delete 0 end
    "
    bind $occ <Control-w> "
	global Active ; set Active($name) 2
	tk_entryBackword %W; tk_entrySeeCaret %W
    "
    bind $occ <Return> "\
	sendToDCC $lrname \[addToHist $name \[%W get\]\]
	%W delete 0 end
    "
    bind $occ <Control-v> "
	global Active ; set Active($name) 2 ; %W insert insert %A
    "
    bind $occ <Control-p> "
	global Active ; set Active($name) 2
	%W delete 0 end ; %W insert insert \[getPrev $name\]
	tk_entrySeeCaret %W
    "
    bind $occ <Control-n> "
	global Active ; set Active($name) 2
	%W delete 0 end ; %W insert insert \[getNext $name\]
	tk_entrySeeCaret %W
    "
    bind $occ <ButtonPress-2> "
	global Active ; set Active($name) 2 ; insertDCCSelect $lrname %W
	tk_entrySeeCaret %W
    "
    focus $occ
    bind $ot <Enter> "focus $occ"
    bind $ot <Configure> "$ot yview -pickplace end"
    bind $oFrm <Enter> "focus $occ"
    bind $oFrm <Visibility> "
	global Icon ; wm iconname $win \$Icon($win)
	global IconBM
	if \[info exists IconBM($win)\] {
	    wm iconbitmap $win \[lindex \$IconBM($win) 0\]
	}
    "
    tkwait visibility $win
    if {$Open(${name})} { wm iconify $win }
}

proc acceptChat {mode conn} {
    global Chat
    case $mode {
    r {
	    global ${conn}Who
	    set nk [set ${conn}Who]
	    set Chat($nk) [accept $conn]
	    global $Chat($nk)Who ; set $Chat($nk)Who $nk
#	    shutdown $conn all
	    filehandler $conn
	    catch "close $conn"
	    unset ${conn}Who
	    makeDCCChannel $nk
	    filehandler $Chat($nk) re dccChat
	    global AChat ; unset AChat($nk);
	}
    e { addText ERROR @info {*** Error on DCC Chat accept}}
    }
}

proc insertDCCSelect {chan ent} {
    if {[catch {set bf [selection get]}] == 0} {
	while {[set nl [string first "\012" $bf]] >= 0} {
	    $ent insert insert [string range $bf 0 [incr nl -1]]
	    tk_entrySeeCaret $ent
	    sendToDCC $chan [$ent get]
	    $ent delete 0 end
	    set bf [string range $bf [incr nl 2] end]
	}
	if {$bf != ""} { $ent insert insert $bf ; tk_entrySeeCaret $ent }
    }
}
proc sendToDCC {chan string args} {
    if {$string != ""} {
	global Chat
	if [info exists Chat($chan)] {
	    if [catch [list puts $Chat($chan) $string] err] {
		addText {} ~${chan} "*** Error : $err"
	    } {
		addText @me ~${chan} "= $string"
	    }
	} {
	    addText {} ~${chan} {*** Connection is closed!!!!}
	}
    }
}

proc doDCCLeave {chan} {
    killChannel ~${chan}
    global Chat
    if [info exists Chat($chan)] {
	set sock $Chat($chan)
#	catch "shutdown $conn all"
	catch "filehandler $sock"
	catch "close $sock"
	global $Chat($chan)Who ; unset $Chat($chan)Who
	unset Chat($chan)
    }
}

proc leaveDCC {chan} {
    mkDialog LEAVE .@${chan} "Leave ${chan}" \
      "Really leave DCC chat with ${chan}?" {} \
      "OK {doDCCLeave ${chan}}" {Cancel {}}
}

proc DCCSend {nk file} {
    if {$file == {}} return
    if [file exists $file] {
	if ![file readable $file] {
	    mkDialog ERROR .@fe {File error} "Cannot read file $file." \
	      {} {OK {}}
	    return
	}
	set file [glob $file]
	set xfile [file tail $file]
	global zircon
	global hostIPAddress
	set port [split [exec $zircon(lib)/dccsend $file [setInfo] $nk]]
	sendCtcp DCC $nk "SEND $xfile [ipPack $hostIPAddress] [lindex $port 0]"
	global ASend ; lappend ASend($nk) [list [lindex $port 1] $file]
	if [winfo exists .@dcclist] buildDCCList
    } {
	mkDialog ERROR .@fe {File error} "File $file does not exist." \
	  {} {OK {}}
    }
}

proc doDCC {cmd nk} {
    if {$nk == {}} return
    set lnk [string tolower $nk]
    case $cmd {
    SEND {
	    mkFileBox .@dccSend$nk "Send $nk" "File to send to $nk" {}\
	      "Send {DCCSend $lnk}" {Cancel {}}
	}
    CHAT {
	    global AChat;
	    if [info exist AChat($lnk)] {
		mkDialog {} .@chat$nk "Chat" \
		  "You already have a chat request open to $nk."  \
		  {} \
		  "Close {unChat $lnk}" {Keep {}}
	    } {
		global hostIPAddress
		if ![catch {connect -server {} 0} sk] {
		    set sock [lindex $sk 0]
		    global ${sock}Who ; set ${sock}Who $lnk
		    global AChat ; set AChat($lnk) $sock
		    filehandler $sock re acceptChat
		    sendCtcp DCC $lnk \
		      "CHAT chat [ipPack $hostIPAddress] [lindex $sk 1]"
		} {
		    addText ERROR @info "*** $host : $sk"
		}
	    }
	}
    }
}

proc closeChat {who conn} {
    if [winfo exists .~$who] {
	addText $who ~$who "*** $who has closed the connection"
    }
#    shutdown $conn all
    filehandler $conn
    catch "close $conn"
    global ${conn}Who ; catch "unset ${conn}Who"
    global Chat ; catch "unset Chat($who)"
}

proc dccChat {mode conn} {
    global ${conn}Who
    set who [set ${conn}Who]
    case $mode in {
    r   {
	    if {[catch "gets $conn" buffer] || $buffer == {}} {
		closeChat $who $conn
	    } {
		addText ${who} ~${who} "=$who= $buffer"
	    }
	}
    e   {  addText {} @info "*** Error on DCC Chat connection with $who" }
    }
}

proc handleInfo {mode conn} {
    case $mode {
    r   {
	    if {[catch "gets $conn" msg] || $msg == {}} {
	 	shutdown $conn all
#		filehandler $conn
		catch "close $conn"
	    } {
		global ASend
		global Send
		global Get
		set sp [split $msg]
		set who [lindex $sp 5]
		set pid [lindex $sp 0]
		set msg [join [lrange $sp 1 end]]
		case $msg {
		{{DCC Send acc*}} { return }
		{{DCC Send conn*}} {
			set x [lsearch $ASend($who) "$pid*"]
			lappend Send($who) [lindex $ASend($who) $x]
			listdel ASend($who) $x
			if {$ASend($who) == {}} {
			    unset ASend($who)
			}
			if [winfo exists .@dcclist] buildDCCList
		    }
		{{DCC Get conn*}} { return }
		{{DCC Send*}} {
			set x [lsearch $Send($who) "$pid*"]
			listdel Send($who) $x
			if {$Send($who) == {}} {
			    unset Send($who)
			}
			if [winfo exists .@dcclist] buildDCCList
		    }
		default {
			set x [lsearch $Get($who) "$pid*"]
			listdel Get($who) $x
			if {$Get($who) == {}} {
			    unset Get($who)
			}
			if [winfo exists .@dcclist] buildDCCList
		    }
		}
		mkInfoBox DCCINFO .@dcc$conn {DCC Info} $msg {OK {}}
	    }
	}
    e   {  addText {} @info "*** Error on DCC Info connection." }
    }
}

proc acceptInfo {mode conn} {
    case $mode {
    r   {
	    set sk [accept $conn]
	    filehandler $sk re handleInfo
	}
    e   {  addText {} @info "*** Error on DCC Info connection (accept)." }
    }
}

proc setInfo {} {
    global dccInfo
    if {$dccInfo == {}} {
	if [catch {connect -server {} 0} dccInfo] {
	    addText {} @info "*** Cannot set up info socket - $dccInfo"
	    return {}
	}
	filehandler [lindex $dccInfo 0] re acceptInfo
    }
    return [lindex $dccInfo 1]
}

proc doGetDCC {wh lnk addr port args} {
    set host [dectonet $addr]
    if {$wh == "Chat"} {
	if [catch {set val [connect $host $port]} msg] {
	    addText {} @info "*** Cannot connect to host $host ($msg)"
	    return 0
	}
	set sok [lindex $val 0]
	global ${sok}Who ; set ${sok}Who $lnk
	makeDCCChannel $lnk
	global Chat ; set Chat($lnk) $sok
	filehandler $sok re dcc${wh}
    } {
	set file [lindex $args 0]
	if [file exists $file] {
	    if ![file writable $file] {
		mkInfoBox {} .@fe {File error} \
		  "Cannot write file $file." {OK {}}
		return
	    }
	}
	global zircon
	set file [file dirname $file]/[file tail $file]
	set pid [exec $zircon(lib)/dccget $host $port $file [setInfo] $lnk]
	global Get ; lappend Get($lnk) [list $pid $file]
    }
}

proc handleDCC {nk lnk param} {
    set pars [split $param]
    case [lindex $pars 1] {
    SEND {
	    if [string match ".*" [set fln [lindex $pars 2]]] {
		set fln _[string range $fln 1 end]
	    }
	    set addr [lindex $pars 3]
	    set port [lindex $pars 4]
	    set msg "DCC Send request ($fln) received from $nk"
	    mkFileBox .@dcc "DCC Get $fln" "$msg" $fln \
	      "Accept {doGetDCC Get $lnk $addr $port}" {Cancel {}}
	}  
    CHAT {
	    set addr [lindex $pars 3]
	    set port [lindex $pars 4]
	    set msg "DCC Chat request ([lindex $pars 2]) received from $nk"
	    mkDialog {} .@dcc "DCC Chat Request" "$msg" {} \
	      "Accept {doGetDCC Chat $lnk $addr $port}" {Cancel {}}
	}
    }
}

proc ipPack {ip} {
    set val 0
    foreach x [split $ip "."] {
	set val [expr {($val << 8) + $x}]
    }
    return [format %u $val]
}

proc dectonet {dec} {
    if {[string length $dec] == 10 && [set first [string index $dec 0]] > 1} {
	case $first {
	    2 {set overflow "0 148 53 119"}
	    3 {set overflow "0 94 208 178"}
	    4 {set overflow "0 40 107 238"}
	}
	set dec [string range $dec 1 end]
    } else {
	set overflow {0 0 0 0}
    }   

    scan [format "%08x" $dec] "%2x%2x%2x%2x" net(3) net(2) net(1) net(0)

    for {set part 0; set carry 0} {$part < 4} {incr part} {
	set sum [expr {$net($part) + [lindex $overflow $part] + $carry}]
	set internet($part) [expr {$sum % 256}]
	set carry [expr {$sum / 256}]
    }

    return "$internet(3).$internet(2).$internet(1).$internet(0)"
}

proc killDel {arr who file} {
    global $arr
    set i 0
    foreach p [set ${arr}($who)] {
	if {[lindex $p 1] == $file} {
	    catch "exec kill [lindex $p 0]"
	    listdel ${arr}($who) $i
	    if {[set ${arr}($who)] == {}} { unset ${arr}($who) }
	    return
	}
	incr i
    }
}

proc unChat who {
    global AChat
    global $AChat($who)Who
    unset $AChat($who)Who
#    catch "shutdown $AChat($who)"
    catch "filehandler $AChat($who)"
    catch "close $AChat($who)"
    unset AChat($who)
}

proc dccClose win {
    foreach t [$win curselection] {
	set x [split [$win get $t]]
	set who [lindex $x 2]
	set file [lindex $x 4]
	case [lindex $x 0] {
	Call* {unChat $who }
	Chat* {doDCCLeave $who}
	Offer* { killDel ASend $who $file }
	Send* { killDel Send $who $file }
	Get* { killDel Get $who $file }
	}
    }
    foreach t [$win curselection] { $win delete $t }
}
