#
#	Procedure to build up a channel window. Conversation windows
#	have fewer buttons and no user area down the side.
#
#	Channel names with characters like $ in them are currently
#	a problem.....
#
proc makePalette chan {
    set w .@p${chan}
    if [winfo exists $w] { wm deiconify $w ; raise $w ; return }
    global Ft
    killWindow $w
    toplevel $w -class Zircon
    wm title $w "${chan} Palette"
    for {set i 2} {$i < 16} {incr i} {
	frame $w.f$i
	for {set j 0} {$j < 16} {incr j} {
	    set c [format "%c" [expr {$i * 16 + $j}]]
	    button $w.f$i.l$j -text $c -relief raised -width 1 \
	      -command ".${chan}.oFrm.cmdLine.commandLine insert insert $c"
	    pack append $w.f$i $w.f$i.l$j left
	}
	pack append $w $w.f$i top
    }
    button $w.ok -text OK -command "destroy $w"
    pack append $w $w.ok fillx
}

proc chanSet {chan array flag} {
    global $array
    chanUpdate [set ${array}(${chan})] ${chan} 0 $flag
}

proc setChanVars chan {
    global popUp ; global Open ; set Open(${chan}) $popUp
    global popDown ; global Close ; set Close(${chan}) $popDown
    global noJump ; global Jump ; set Jump(${chan}) $noJump
    global quiet ; global Quiet ; set Quiet(${chan}) $quiet
    global Actions ; set Actions(${chan}) 0
    foreach auto [getAuto ${chan}] {
	case $auto {
	open { set Open(${chan}) 1 }
	close { set Close(${chan}) 1 }
	nojump { set Jump(${chan}) 1 }
    	quiet { set Quiet(${chan}) 1 }
	}
    }
    global History ;
    if {[set History(${chan}) [getHistory ${chan}]] == {} } {
	global history ; set History(${chan}) $history
    }
    global CloseTime
    global closeTime
    if {[set CloseTime(${chan}) [getCloseTime ${chan}]] == {} } {
	set CloseTime(${chan}) $closeTime
    } {
	set CloseTime(${chan}) [expr {$CloseTime(${chan}) * 1000}]
	global testTime
	if {$CloseTime(${chan}) < $testTime} {
	    set testTime $CloseTime(${chan})
	}
	if {$closeTime == 0} { set closeTime $CloseTime(${chan}) }
    }
    global testTime
    if {$CloseTime(${chan}) != 0 && $CloseTime(${chan}) < $testTime} {
	set testTime $CloseTime(${chan})
    }
    global CloseCount
    set CloseCount(${chan}) $CloseTime($chan)
}

proc makeChannel {name type} {
    set name [string tolower ${name}]
    global HPos ; set HPos(${name}) 0
    global HBuff ; set HBuff(${name}) {}
    global Active ; set Active(${name}) 0
    setChanVars ${name}
    set realChan [expr {[channel $name] && $type != "M"}]
    if [winfo exists .$name] { wm deiconify .$name ; raise .$name ; return}
    if {[set dot [string first "." $name]] >= 0} {
	set bits [split $name .]
	set name [lindex $bits 0]
	set win .$name
	toplevel $win -class Zircon
	set prv $win
	foreach bit [lrange $bits 1 end] {
	    append name ".$bit"
	    frame .$name -border 0
	    pack append $prv .$name {expand}
	    set prv .$name
	}
    } {
	set win .$name
	toplevel $win -class Zircon
    }
    global Name ; set Name($win) $name
    global activeChannels
    if {[lsearch $activeChannels $name] < 0 && $type != "N"} {
	lappend activeChannels $name
    }
    if $realChan {
	set hgh 24
	wm title $win "IRC Channel $name"
    } {
	case $type {
	N {set type "Notice from" ; set hgh 10}
	default {set type "Conversation with" ; set hgh 16}
	}
	wm title $win "IRC $type $name"
    }
    wm minsize $win 40 1
    setIcon $win $name $name

    set w .$name
    set oFrm [frame .$name.oFrm -relief raised]

    if {$realChan} {
	set wu [frame $w.users -relief raised]
	scrollbar $wu.vscroller -command "$wu.userList yview" 
	canvas $wu.userList -yscrollcommand "$wu.vscroller set"
	frame $wu.userList.frame -border 0
	$wu.userList create window 0 0 -window $wu.userList.frame -anchor nw
	zpack $wu {userList vscroller} {left filly} 
	zpack $w users {right filly}

	global lcNickname
	global nickname
	global ${name}Spk
	global ${name}Op ; set ${name}Op($lcNickname) 0
	set ${name}Spk($lcNickname) 0
	menubutton $wu.userList.frame.@me -text $nickname \
	  -menu $wu.userList.frame.@me.menu
	makeUserMenu ${name} $wu.userList.frame.@me.menu $lcNickname 0 0
	set wd [winfo reqwidth $wu.userList.frame.@me]
	set ht [winfo reqheight $wu.userList.frame.@me] 
	$wu.userList conf -width $wd  -scrollincrement $ht \
	  -scrollregion [list 0 0 $wd $ht]
	zpack $wu.userList.frame @me {}
	frame $oFrm.topic
	menubutton $oFrm.topic.label -text Topic -relief raised
	$oFrm.topic.label conf -menu $oFrm.topic.label.menu
	set om [menu $oFrm.topic.label.menu]
	$om add command -label New -command "getTopic ${name}"
	$om add separator
	foreach nn [getTopics ${name}] {
	    $om add command -label "[prune $nn]" \
	      -command "doTopic ${name} {${nn}}"
	}
	emacsTEntry $oFrm.topic.entry -relief raised
	zpack $oFrm.topic label left
	zpack $oFrm.topic entry {left expand fillx}
	bind $oFrm.topic.entry <Return> {sendTopic %W ; notIdle %W}
    }

    frame $oFrm.cmds -borderwidth 0
    set of [frame $oFrm.cmds.cmds0]
    set om [makeMB $of.mode Mode]
    $om add checkbutton -label {Pop Up} -variable Open($name) \
	-command "chanSet ${name} Open open"
    $om add checkbutton -label {Pop Down} -variable Close($name) \
	-command "chanSet ${name} Close close"
    $om add checkbutton -label {No Jump} -variable Jump($name) \
	-command "chanSet ${name} Jump nojump"
    $om add checkbutton -label Quiet -variable Quiet($name) \
	-command "chanSet ${name} Quiet quiet"
    $om add checkbutton -label Actions -variable Actions($name) \
      -command "flipActions $name"
    global modeStart ; set modeStart [$om index last]

    if $realChan {
	global ${name}
	foreach vl {{p Private} {m Moderated} {s Secret} {i {Invite Only}} \
	  {t Topic} {n {No Msg}}} {
	    set v [lindex $vl 0]
	    set ${name}($v) 0
	    $om add checkbutton -command "changeMode $name $v" \
	      -variable ${name}(${v}) -state disabled -label [lindex $vl 1]
	}	
	$om add command -command "setBan $name" -state disabled -label Ban
	$om add command -command "setLimit $name" -state disabled -label Limit
	$om add command -command "setKey $name" -state disabled -label Key

	set om [makeMB $of.channel Channel]
	$om add command -command "sendIRC WHO $name" -label Who
	$om add command -command "channelInvite $name" -label Invite
	$om add command -command "channelNotice $name" -label Notice
	addCTCPMenu $om $name
    } {
	set om [makeMB $of.channel User]
	$om add command -command "sendIRC WHOIS ${name}" -label Whois
	$om add command  -command "channelNotice $name" -label Notice
	addCTCPMenu $om $name
	addDCCMenu $om $name
    }
    $om add cascade -label Log -menu $om.log
    menu $om.log
    foreach cmd {Close Open Flush Empty} {
	$om.log add command -label $cmd -command "doLog ${name} $cmd" \
	  -state disabled
    }
    global LogFile
    if {[set LogFile(${name}) [getLog ${name}]] != {}} {
	global Log
	if [catch "open $LogFile(${name}) a" Log(${name})] {
	    addText ERROR @info \
	      "*** Cannot open log file $LogFile(${name}) for channel ${name} : $Log(${name})"
	    unset Log(${name})
	    $om.log entryconfigure 1 -state normal
	} {
	    $om.log entryconfigure 0 -state normal
	    $om.log entryconfigure 2 -state normal
	    $om.log entryconfigure 3 -state normal
	}
    } {
	$om.log entryconfigure 1 -state normal
    } 
    set om [makeMB $of.action Action]
    $om add command -label New -command "getAction $name"
    $om add separator

    global actions
    foreach act $actions {
	$om add command -label "[prune $act]" -command "sendAction $name {$act}"
    }
    frame $oFrm.cmds.cmds1
    button $oFrm.cmds.cmds1.quit -command "leaveChannel $name" -text Leave
    bind $oFrm.cmds.cmds1.quit <Shift-1> {tk_butDown %W}
    bind $oFrm.cmds.cmds1.quit <Shift-ButtonRelease-1> {
	set sc [%W configure -command]
	%W configure -command quitZircon
	tk_butUp %W
	%W configure -command $sc
    }

    button $oFrm.cmds.cmds1.clear -command "clearChannel $name 0" -text Clear
    bind $oFrm.cmds.cmds1.clear <Shift-1> {tk_butDown %W}
    bind $oFrm.cmds.cmds1.clear <Shift-ButtonRelease-1> "
	set sc \[%W configure -command\]
	%W configure -command {clearChannel $name 1}
	tk_butUp %W
	%W configure -command \$sc
    "
    zpack $of {mode channel action} {left expand fillx} 
    tk_menuBar $oFrm.cmds.cmds0 $oFrm.cmds.cmds0.mode \
      $oFrm.cmds.cmds0.channel $oFrm.cmds.cmds0.action

    zpack $oFrm.cmds.cmds1 {quit clear} {left expand fillx} 
    zpack $oFrm.cmds {cmds0 cmds1} {left expand fillx}

    set oft [frame $oFrm.textFrm -relief raised]
    scrollbar $oft.vscroller -command "$oft.text yview"
    set ot [text $oft.text -yscrollcommand "$oft.vscroller set" -height $hgh]
    rebind $ot
    global BF
    global Fg
    global Bg
    global Ft
    set BF($name) [getOValue $ot font boldFont Font]
    set Ft($name) [getOValue $ot font font Font]
    set Fg($name) [getOValue $ot foreground foreground Foreground]
    set Bg($name) [getOValue $ot background background Background]
    $oft.text conf -selectforeground $Bg($name) -selectbackground $Fg($name)
    zpack $oft vscroller {right filly} 
    zpack $oft text {left expand fill}

    set om [frame $oFrm.cmdLine -relief raised]
    scrollbar $om.cscroller -orient horizontal -command "$om.commandLine view"
    emacsEntry $om.commandLine -scrollcommand "$om.cscroller set"
    zpack $om {commandLine cscroller} {expand fillx}

    if {$realChan} { zpack $oFrm topic fillx }

    zpack $oFrm cmds {top fillx}
    zpack $oFrm cmdLine {bottom fillx}
    zpack $oFrm textFrm {expand fill}
    zpack $w oFrm {left expand fill}

    set occ $oFrm.cmdLine.commandLine
    bind $occ <Meta-b> \
      { notIdle %W ; %W insert insert \002 ;tk_entrySeeCaret %W }
    bind $occ <Meta-v> \
      { notIdle %W ; %W insert insert \026 ; tk_entrySeeCaret %W }
    bind $occ <Meta-u> \
      { notIdle %W ; %W insert insert \037 ; tk_entrySeeCaret %W }
    bind $occ <Meta-s> {
	notIdle %W
	global smiley ; %W insert insert $smiley
	tk_entrySeeCaret %W
    }
    bind $occ <Shift-Meta-S> {
	notIdle %W
	global scowl ; %W insert insert $scowl
	tk_entrySeeCaret %W
    }
    bind $occ <Control-Meta-s> {
	notIdle %W
	global wink ; %W insert insert $wink
	tk_entrySeeCaret %W
    }
    bind $occ <Meta-j> {
	notIdle %W
	if {![catch {selection get} bf] && $bf != {}} { channelJoin $bf }
    }
    bind $occ <Meta-m> {
	notIdle %W
	if {![catch {selection get} bf] && $bf != {}} {
	    makeChannel [string range $bf 0 8] M
	}
    }
    bind $occ <Meta-f> {
	notIdle %W
	if {![catch {selection get} bf] && $bf != {}} {
	    finger [string range $bf 0 8]
	}
    }
    bind $occ <Any-KeyPress> {
	notIdle %W
	if {"%A" != {}} { %W insert insert %A ; tk_entrySeeCaret %W }
    }
    bind $occ <Delete> \
      { notIdle %W ; tk_entryBackspace %W; tk_entrySeeCaret %W }
    bind $occ <BackSpace> \
      { notIdle %W ; tk_entryBackspace %W; tk_entrySeeCaret %W }
    bind $occ <Control-h> \
      { notIdle %W ; tk_entryBackspace %W; tk_entrySeeCaret %W }
    bind $occ <Control-d> { notIdle %W ; %W delete insert }
    bind $occ <Control-u> { notIdle %W ; %W delete 0 end }
    bind $occ <Control-w> \
      { notIdle %W ; tk_entryBackword %W; tk_entrySeeCaret %W }
    bind $occ <Escape> " notIdle %W ; makePalette ${name} "
    bind $occ <Return> "
	sendToChannel $name \[addToHist $name \[%W get\]\]
	%W delete 0 end
    "
    bind $occ <Shift-Return> "
	sendAction $name \[addToHist $name \[%W get\]\]
	%W delete 0 end
    "
    bind $occ <Control-Return> "
	doNotice $name \[addToHist $name \[%W get\]\]
	%W delete 0 end
    "
    bind $occ <Control-p> "
	notIdle %W
	%W delete 0 end ; %W insert insert \[getPrev $name\]
	tk_entrySeeCaret %W
    "
    bind $occ <Control-n> "
	notIdle %W
	%W delete 0 end ; %W insert insert \[getNext $name\]
	tk_entrySeeCaret %W
    "
    bind $occ <ButtonPress-2> "
	notIdle %W
	insertSelect $name %W
	tk_entrySeeCaret %W
    "
    setBindings $occ ${name}
    focus $occ
    bind $ot <Enter> "focus $occ ; notIdle %W"
    bind $ot <Configure> {%W yview -pickplace end ; notIdle %W}
    bind $oFrm <Enter> "focus $occ ; notIdle %W"
    bind $oFrm <Visibility> {
	set win [winfo toplevel %W]
	global Icon
	if [info exists Icon($win)] {wm iconname $win $Icon($win)}
	global IconBM
	if [info exists IconBM($win)] {
	    wm iconbitmap $win [lindex $IconBM($win) 0]
	}
	notIdle %W
    }
    tkwait visibility $w
    global Open ; if $Open(${name}) { wm iconify $win }
    if {$realChan} { sendIRC MODE $name }
}
