/** This is a test of the Tk toolkit on the C level **/

#include <stdio.h>

/** Now the Tk header files **/

#include <tk.h>

/* now the X files */
#include <X11/cursorfont.h>

/** now the local files **/

#include "newscomm.h"
#include "tcp.h"

/* defines */

#define MAX_WINS 255 /* maximum number of windows our application will have */
#define SC_WAIT 1 /* specifies the wait mode for our application */
#define SC_NORMAL 2 /* specified the normal mode for our application */

/* globals */
Tk_Window mainwin;
Window busy_win = -1;

/*
 * This TCL command returns a random number.
 */
int
  RandNumCmd(junk,interp,argc,argv)
ClientData junk;
Tcl_Interp *interp;
int        argc;
char       **argv;
{
  int num;

  if (argc != 2) {
    Tcl_AppendResult(interp, "Wrong # args: should be \"", argv[0], 
		     "num\"", (char *) NULL);
    return TCL_ERROR;
  }
  num = rand()%atoi(argv[1]); 
  interp->result = (char *) malloc(100);
  sprintf(interp->result, "%d", num);
  return TCL_OK;
}

/*
 * This command presents an interface to strftime
 */
int 
  StrftimeCmd(junk,interp,argc,argv)
ClientData junk; 
Tcl_Interp *interp;
int        argc;
char       **argv;
{
  struct tm *tm;
  time_t t;
  char   buf[30];

  if (argc != 3) {
    Tcl_AppendResult(interp, "Wrong # args : should be \"", argv[0],
		     " <time> <format-string>\"", (char *) NULL);
    return TCL_ERROR;
  }
  t = atol(argv[1]);
  tm = (struct tm *) localtime(&t);
  strftime(buf, 29, argv[2], tm);
  Tcl_AppendResult(interp, buf, (char *) NULL);
  return TCL_OK;
}

  

/*
 * This tcl command sets all of the applications windows' cursors to
 * the state indicated (wait or normal).
 */
int
    SetCursorCmd(junk, interp, argc, argv)
ClientData junk;
Tcl_Interp *interp;
int argc;
char **argv;
{
    int wait_mode;

    if (argc != 2) {
	Tcl_AppendResult(interp, "Wrong # args: should be \"", argv[0],
			 " wait|normal\"", (char *) NULL);
	return TCL_ERROR;
    }
    if (!strcmp(argv[1], "wait")) {
	wait_mode = 1;
    } else {
	wait_mode = 0;
    }
    if (busy_win == (Window) -1) {
	XSetWindowAttributes attr;
	unsigned long valuemask;

	valuemask = CWDontPropagate | CWCursor;
	attr.do_not_propagate_mask = (ButtonPressMask | ButtonReleaseMask | PointerMotionMask);
	attr.cursor = XCreateFontCursor(Tk_Display(mainwin), XC_watch);
	busy_win = XCreateWindow(Tk_Display(mainwin), Tk_WindowId(mainwin), 0, 0,
				 3000, 3000, (unsigned int) 0, CopyFromParent, InputOnly,
				 CopyFromParent, valuemask, &attr);
    }
    if (wait_mode) {
	XMapRaised(Tk_Display(mainwin), busy_win);
    } else {
	XUnmapWindow(Tk_Display(mainwin), busy_win);
    }
    return TCL_OK;
}

/* This tcl command returns the x and y coordinates of the pointer */
int
  QueryPointerCmd(junk, interp, argc, argv) 
ClientData  junk;
Tcl_Interp  *interp;
int         argc;
char        **argv;
{
  char *ret;
  Window rw,cw;
  int xr,yr,xw,yw;
  unsigned int keys_buttons;

  if (argc != 1) {
    Tcl_AppendResult(interp, "Wrong # args: shouldbe \"", argv[0],
		     (char *) NULL); 
    return TCL_ERROR;
  }
  
  XQueryPointer(Tk_Display(mainwin), DefaultRootWindow(Tk_Display(mainwin)),
		&rw, &cw, &xr, &yr, &xw, &yw, &keys_buttons);
  ret = (char *) malloc(20);
  sprintf(ret, "%d %d", xr, yr);
  interp->result = ret;
  return TCL_OK;
}
  
/*
 * This command strips the argument string of all control characters
 * except for tab, and returns the resulting string
 *
 */

int
  ControlStripCmd(junk, interp, argc, argv)
ClientData junk;
     Tcl_Interp *interp;
     int        argc;
     char       **argv;
{
  char *string;
  char *sreturn;
  int  i,count;

  if (argc != 2) {
    Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		     " string\"", (char *) NULL);
    return TCL_ERROR;
  }
  string = argv[1];
  if (string == (char *) NULL) {
    return TCL_ERROR;
  }
  sreturn = (char *) malloc (strlen(string)+1);
  count = 0;
  for (i = 0; i < strlen(string); i++) {
    if ((string[i] < 32 || string[i] > 126) && string[i] != '\t' &&
	string[i] != '\n') { 
      /* don't put it in the return string */
      if (string[i] == 27) {
	/* escape sequence, must parse to ignore.. ugh */
	i++; 
	i++;
	if (string[i] >= '0' && string[i] <= '9')  {
	  i++;
	}
      }
    }
    else {
      sreturn[count] = string[i];
      count++;
    }
  }
  sreturn[count] = '\0';
  interp->result = sreturn;
  return TCL_OK;
}

static void 
DelayedMap(clientData)
     ClientData clientData; /* not used */
{
  while (Tk_DoOneEvent(TK_IDLE_EVENTS) != 0) {
    /* empty loop body */
  }
  Tk_MapWindow(mainwin);
}

main(argc, argv)
     int argc;
     char **argv;
{
  Tcl_Interp *interpreter;
  char cmd[300];
  char old, *msg;
  int i;
  char *args, buf[20];
  
  if (argc == 1) {
    sprintf(cmd, "tknews.t");
  }
  else {
    sprintf(cmd, "%s.t", argv[1]);
  }
  srand(time((time_t *) NULL));
  interpreter = Tcl_CreateInterp();
  mainwin = Tk_CreateMainWindow(interpreter, (char *) NULL, "Tknews"); 
  if (mainwin == NULL) {
    fprintf(stderr, "Cannot open display.  Please check your DISPLAY environment variable.\n");
    exit(0);
  }
  /* 
   * Make command-line arguments available in the Tcl variables "argc"
   * and "argv".
   */
  args = Tcl_Merge(argc-1,argv+1);
  Tcl_SetVar(interpreter, "argv", args, TCL_GLOBAL_ONLY);
  ckfree(args);
  sprintf(buf, "%d", argc-1);
  Tcl_SetVar(interpreter, "argc", buf, TCL_GLOBAL_ONLY);
  /* create our custom TCL commands */
  Tcl_CreateCommand(interpreter, "strftime", StrftimeCmd,
		    (ClientData) 0, (void (*)()) NULL);
  Tcl_CreateCommand(interpreter, "randnum", RandNumCmd,
		    (ClientData) 0, (void (*)()) NULL);
  Tcl_CreateCommand(interpreter, "strip_controls", ControlStripCmd, 
		    (ClientData) 0, (void (*)()) NULL); 
  Tcl_CreateCommand(interpreter, "query_pointer", QueryPointerCmd,
		    (ClientData) 0, (void (*)()) NULL); 
  Tcl_CreateCommand(interpreter, "set_cursor", SetCursorCmd,
		    (ClientData) 0, (void (*)()) NULL);
  Tcl_CreateCommand(interpreter, "GetArticleList", GetArticleListCmd,
		    (ClientData) 0, (void (*)()) NULL);
  Tcl_CreateCommand(interpreter, "connect", Tcp_ConnectCmd,
		    (ClientData) 0, (void (*)()) NULL);
  Tcl_CreateCommand(interpreter, "LoadActiveList", LoadActiveListCmd,
		    (ClientData) 0, (void (*)()) NULL);
  Tcl_CreateCommand(interpreter, "InverseRange", InverseRangeCmd,
		    (ClientData) 0, (void (*)()) NULL);
  Tcl_CreateCommand(interpreter, "SaveNewsrc", SaveNewsrcCmd,
		    (ClientData) 0, (void (*)()) NULL);
  Tcl_CreateCommand(interpreter, "LoadNewsrc", LoadNewsrcCmd,
		    (ClientData) 0, (void (*)()) NULL);
  Tcl_CreateCommand(interpreter, "FileGetLine", FileGetLineCmd,
		    (ClientData) 0, (void (*)()) NULL);
  Tcl_CreateCommand(interpreter, "GetFile", GetFileCmd,
		    (ClientData) 0, (void (*)()) NULL);
  Tcl_CreateCommand(interpreter, "lisort", Tcl_LisortCmd,
		    (ClientData) 0, (void (*)()) NULL);
  Tcl_CreateCommand(interpreter, "gethostname", GetHostnameCmd,
		    (ClientData) 0, (void (*)()) NULL);

  old = cmd[0];
  cmd[0] = toupper(cmd[0]);
  Tk_SetClass(mainwin, cmd);
  cmd[0] = old; 
  Tk_GeometryRequest(mainwin, 100, 150);
  Tk_SetWindowBackground(mainwin, WhitePixelOfScreen(Tk_Screen(mainwin)));
  Tk_DoWhenIdle(DelayedMap, (ClientData) NULL);
  Tcl_SetVar(interpreter, "SCRIPT_DIR", SCRIPT_DIR, TCL_GLOBAL_ONLY);
  Tcl_SetVar(interpreter, "LIBRARY_DIR", LIBRARY_DIR, TCL_GLOBAL_ONLY);
  i = Tcl_VarEval(interpreter, "source ", SCRIPT_DIR, "/nwish.tcl", (char **) NULL);
  
  if (i != TCL_OK) {
    printf("error in initCmd.\n");
    printf("%s\n",interpreter->result);
    exit(0);
  }
  /*
   * Load in the configuration paramters so that the scripts
   * which run under the driver know where to look for things.
   */
  i = Tcl_VarEval(interpreter, "source ", 
		  SCRIPT_DIR, "/config.t", (char *) NULL);
  if (i != TCL_OK) {
    printf("Error reading configuration file '%s/config'!\n", SCRIPT_DIR);
    msg = Tcl_GetVar(interpreter, "errorInfo", TCL_GLOBAL_ONLY);
    if (msg == NULL) {
      msg = interpreter->result;
    }
    printf("%s\n",msg);
    exit(0);
  }
  i = Tcl_VarEval(interpreter, "source ", 
		  SCRIPT_DIR, "/", "tknews.t", (char *) NULL);
  if (i != TCL_OK) {
    printf("Error reading file '%s/%s'!\n",SCRIPT_DIR, cmd);
    msg = Tcl_GetVar(interpreter, "errorInfo", TCL_GLOBAL_ONLY);
    if (msg == NULL) {
      msg = interpreter->result;
    }
    printf("%s\n",msg);
    exit(0);
  }
  (void) Tcl_Eval(interpreter, "update", 0, (char **) NULL);
  Tk_MainLoop();
}
  

