#
# This procedure binds a button for drag and drop.
#
proc bind_for_dragndrop {w} {
    bind $w <ButtonPress-1> "start_drag %W %X %Y"
    bind $w <B1-Motion> "do_drag %W %X %Y"
    bind $w <ButtonRelease-1> "do_drop %W %X %Y"
}

proc start_drag {w x y} {
    global dragx dragy dragging textbuffer
    global startx starty selectedtext
    
    set startx $x
    set starty $y
    
    set dragx $x
    set dragy $y
    set dragging 0
}

proc do_drag {w x y} {
    global dragx dragy dragging textbuffer
    global Mode
    
    if (!$dragging) {
	if {$Mode != "Articles"} {
	    return
	}
	set dx [expr $dragx-$x]
	set dy [expr $dragy-$y]
	if ($dx>8||$dx<-8||$dy>8||$dy<-8) {
	    dnd_set_cursor $w
	    set dragging 1
	}
    }
}

proc do_drop {w x y} {
    global dragging inwin textbuffer
    global startx starty
    global GroupTable GroupIndex CurrentArticle
    
    
    #update makes sure any Enter/Leave events have happened (at least locally)
    update
    if (!$dragging) {
	return
    } else {
	set dragging 0
	dnd_reset_cursor $w
	if (!$inwin) {
	    #save to /tmp, and copy from there.
	    set text [get_article $GroupTable($GroupIndex,name) $CurrentArticle]
	    set i [catch {set file [open "/tmp/tknewsart-$CurrentArticle" "w"]}]
	    if {$i} {
		option_dialog .oops 800 "Drop Error" "System Error!!!\nDrop Aborted" OK
		return
	    }
	    puts $file $text
	    close $file
	    foreach a [winfo interps] {
		#skip current window
		if {[string compare $a [winfo name .]]} {
		    if [catch {send $a get_drop $x $y buffer "filetype" "/tmp/tknewsart-$CurrentArticle" "Article-$CurrentArticle" [winfo name .]} errmsg] {
			#puts stdout $errmsg
		    }
		}
	    }
	}
    }
}

proc dnd_set_cursor {w} {
    global Resources LIBRARY_DIR

    set cur @$LIBRARY_DIR/bitmaps/article.xbm
    set mask $LIBRARY_DIR/bitmaps/article.mask
    $w config -cursor "$cur $mask black white"
}

proc dnd_reset_cursor {w} {
    $w config -cursor top_left_arrow
}
