#
# This library file provides the mechanism for using the
# standard X Resource files with a Tk program.
#


# envVal envValName
#   Looks up the envValName environment variable and returns its
#   value, or {} if it does not exists

proc envVal {envValName} {
    global env
    if [info exists env($envValName)] {return $env($envValName)} {return {}}
}

# loadAppDefaults classNameList ?priority?
#   Searches for the app-default files corresponding to classNames in
#   the order specified by X Toolkit Intrinsics, and loads them with
#   the priority specified (default: startupFile).

proc loadAppDefaults {mode classNameList {priority startupFile}} {
    global Resources LIBRARY_DIR Options

    set filepath "[split [envVal XUSERFILESEARCHPATH] :] \
		[envVal RESOURCEDIR] \
                [envVal XAPPLRESDIR] \
                [split [envVal XFILESEARCHPATH] :] \
                /usr/lib/X11"
    
    if {[info exists LIBRARY_DIR]} {
	if {[info exists Options(Gce)]} {
	    if {$Options(Gce)} {			
		set postfix "tknewsrc-gce"
	    } else {
		set postfix "tknewsrc"
	    }
	} else {
	    set postfix "tknewsrc"
	}
	if {[file exists "$LIBRARY_DIR/$postfix"]} {
	    option readfile "$LIBRARY_DIR/$postfix" widgetDefault
	}
    }
    foreach i $classNameList {
	set depth [winfo depth .]
	if {$depth < 8} {
	    append i ".bw"
	}
	foreach j $filepath {
	    if {[file exists $j/$i]} {
		if {$mode == "option"} {
		    option readfile $j/$i $priority; break
		} else {
		    if {$mode == "config"} {
			config_parse_file $j/$i; break; 
		    } else {
			error "Invalid mode option (must be config or option)."
		    }
		}
	    }
	}
    }
    if {[info exists Resources(TKNEWSRC)]} {
	if {[file exists $Resources(TKNEWSRC)]} {
	    option readfile $Resources(TKNEWSRC) $priority
	}
    
    }
    
}


