/*
 *  Copyright (C) 1993 Michael Tiller
 *
 *  Permission is hereby granted by the author to use, copy, modify,
 *  and distribute this code for any purpose provided this copyright
 *  notice is included in all copies.  This code is provided "as is"
 *  without any expressed or implied warranty.
 *
 */


/* Although this file provides TCL support, it is not mandatory that
   this library be used in conjunction with TCL */

#include	<tcl.h>
#include	<stdio.h>
#include	<malloc.h>
#include	"sub.h"

static int
cmdAuxExpr(ClientData clientData, Tcl_Interp *interp, int argc,
	char *argv[])
{
	char	*res;
	if (argc != 2 || argv[1]==NULL)
	{
		Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
			" expr\"", (char *) NULL);
		return	TCL_ERROR;
	}
	res = eval_expr(argv[1]);
	if (res==NULL)
	{
		Tcl_AppendResult(interp, "syntax error", (char *) NULL);
		return	TCL_ERROR;
	}

	Tcl_SetResult(interp, res, TCL_DYNAMIC);
	return TCL_OK;
}

static int
cmdAtToDollar(ClientData clientData, Tcl_Interp *interp, int argc,
	char *argv[])
{
	char	*res, *ptr;

	if (argc !=2 || argv[1]==NULL)
	{
		Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
			" string\"", (char *) NULL);
		return	TCL_ERROR;
	}
	res = (char *)malloc(strlen(argv[1])+1);
	strcpy(res, argv[1]);
	for(ptr=res;*ptr!='\0';ptr++)
		if (*ptr=='@')
			*ptr='$';

	Tcl_SetResult(interp, res, TCL_DYNAMIC);
	return TCL_OK;
}

static int
cmdDeriv(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	char	*res;
	if (argc != 3 || argv[1]==NULL || argv[2]==NULL)
	{
		Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
			" expr var\"", (char *) NULL);
		return	TCL_ERROR;
	}
	res = take_deriv(argv[1], argv[2], 0);
	if (res==NULL)
	{
		Tcl_AppendResult(interp, "syntax error", (char *) NULL);
		return	TCL_ERROR;
	}

	Tcl_SetResult(interp, res, TCL_DYNAMIC);
	return TCL_OK;
}

static int
cmdTDeriv(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	char	*res;
	if (argc != 3 || argv[1]==NULL)
	{
		Tcl_AppendResult(interp, "wrong # args: should be ", argv[0],
			" expr var", (char *) NULL);
		return	TCL_ERROR;
	}
	res = take_deriv(argv[1], argv[2], 1);
	Tcl_SetResult(interp, res, TCL_DYNAMIC);
	return TCL_OK;
}

void
tclDerivCmdInit(Tcl_Interp *interp)
{
	Tcl_CreateCommand(interp, "deriv", cmdDeriv, (ClientData) 0,
		(Tcl_CmdDeleteProc *) NULL);
	Tcl_CreateCommand(interp, "total_deriv", cmdTDeriv, (ClientData) 0,
		(Tcl_CmdDeleteProc *) NULL);
	Tcl_CreateCommand(interp, "at_to_dollar", cmdAtToDollar, (ClientData) 0,
		(Tcl_CmdDeleteProc *) NULL);
	Tcl_CreateCommand(interp, "aux_expr", cmdAuxExpr, (ClientData) 0,
		(Tcl_CmdDeleteProc *) NULL);
}
