'\"
'\" Copyright 1990-1992 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /rel/cvsfiles/unsupported/latest/tk/doc/pack.n,v 1.1 1993/01/24 05:00:04 zoo Exp $ SPRITE (Berkeley)
'/" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS pack cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
pack \- Geometry manager that packs around edges of cavity
.SH SYNOPSIS
\fBpack after \fIsibling \fIwindow options\fR ?\fIwindow options \fR...?
.sp
\fBpack append \fIparent \fIwindow options\fR ?\fIwindow options \fR...?
.sp
\fBpack before \fIsibling \fIwindow options\fR ?\fIwindow options \fR...?
.sp
\fBpack info \fIparent\fR
.sp
\fBpack unpack \fIwindow\fR
.BE

.SH DESCRIPTION
.PP
The packer is a geometry manager that arranges the
children of a parent by packing them in order around the edges of
the parent.  The first child is placed against one side of
the window, occupying the entire span of the window along that
side.  This reduces the space remaining for other children as
if the side had been moved in by the size of the first child.
Then the next child is placed against one side of the remaining
cavity, and so on until all children have been placed or there
is no space left in the cavity.
.PP
The \fBbefore\fR, \fBafter\fR, and \fBappend\fR forms of the \fBpack\fR
command are used to insert one or more children into the packing order
for their parent.  The \fBbefore\fR form inserts the children before
window \fIsibling\fR in the order;  all of the other windows must be
siblings of \fIsibling\fR.  The \fBafter\fR form inserts the windows
after \fIsibling\fR, and the \fBappend\fR form appends one or more
windows to the end of the packing order for \fIparent\fR.  If a
\fIwindow\fR named in any of these commands is already packed in
its parent, it is removed from its current position in the packing
order and repositioned as indicated by the command.  All of these
commands return an empty string as result.
.PP
.VS
The \fBunpack\fR form of the \fBpack\fR command removes \fIwindow\fR
from the packing order of its parent and unmaps it.  After the
execution of this command the packer will no longer manage
\fIwindow\fR's geometry.
.VE
.PP
The placement of each child is actually a four-step process;
the \fIoptions\fR argument following each \fIwindow\fR consists of
a list of one or more fields that govern the placement of that
window.  In the discussion below, the term \fIcavity\fR refers
to the space left in a parent when a particular child is placed
(i.e. all the space that wasn't claimed by earlier children in
the packing order).  The term \fIframe\fR refers to the space
allocated to a particular child;  this is not necessarily the
same as the child window's final geometry.
.PP
The first step in placing a child is to determine which side of
the cavity it will lie against.  Any one of the following options
may be used to specify a side:
.TP
\fBtop\fR
Position the child's frame against the top of the cavity,
occupying the full width of the cavity.
.TP
\fBbottom\fR
Position the child's frame against the bottom of the cavity,
occupying the full width of the cavity.
.TP
\fBleft\fR
Position the child's frame against the left side of the cavity,
occupying the full height of the cavity.
.TP
\fBright\fR
Position the child's frame against the right side of the cavity,
occupying the full height of the cavity.
.LP
At most one of these options should be specified for any given window.
If no side is specified, then the default is \fBtop\fR.
.PP
The second step is to decide on a frame for the child.  For \fBtop\fR
and \fBbottom\fR windows, the desired frame width is normally the cavity
width and the desired frame height is the window's requested height,
as passed to \fBTk_GeometryRequest\fR. For \fBleft\fR and \fBright\fR
windows, the desired frame height is normally the cavity height and the
desired width is the window's requested width.  However, extra
space may be requested for the window using any of the following
options:
.TP 12
\fBpadx \fInum\fR
Add \fInum\fR pixels to the window's requested width before computing
the frame size as described above.
.TP 12
\fBpady \fInum\fR
Add \fInum\fR pixels to the window's requested height before computing
the frame size as described above.
.TP 12
\fBexpand\fR
This option requests that the window's frame absorb any extra space left over
in the parent's cavity after packing all the children.
The amount of space left over depends on the sizes requested by the
other children, and may be zero.  If several windows have all specified
\fBexpand\fR then the extra width will be divided equally among all the
\fBleft\fR and \fBright\fR windows that specified \fBexpand\fR and
the extra height will be divided equally among all the \fBtop\fR and
\fBbottom\fR windows that specified \fBexpand.
.LP
If the desired width or height for a frame is larger than the corresponding
dimension of the cavity, then the cavity's dimension is used instead.
.PP
The third step in placing the window is to decide on the window's
width and height.  The default is for the window to receive either
its requested width and height or the those of the frame, whichever
is smaller.  If the frame is larger than the window's requested
size, then the following options may be used to expand the
window to partially or completely fill the frame:
.TP
\fBfill\fR
Set the window's size to equal the frame size.
.TP
\fBfillx\fR
Increase the window's width to equal the frame's width, but retain
the window's requested height.
.TP
\fBfilly\fR
Increase the window's height to equal the frame's height, but retain
the window's requested width.
.PP
The last step is to decide the window's location within its frame.
If the window's size equals the frame's size, then the window simply
fills the entire frame.  If the frame is larger than the window,
then one of
the following options may be used to specify where the window should
be positioned within its frame:
.TP 15
\fBframe center\fR
Center the window in its frame.  This is the default if no framing
option is specified.
.TP 15
\fBframe n\fR
Position the window with its top edge centered on the top edge of
the frame.
.TP 15
\fBframe ne\fR
Position the window with its upper-right corner at the upper-right corner
of the frame.
.TP 15
\fBframe e\fR
Position the window with its right edge centered on the right edge of
the frame.
.TP 15
\fBframe se\fR
Position the window with its lower-right corner at the lower-right corner
of the frame.
.TP 15
\fBframe s\fR
Position the window with its bottom edge centered on the bottom edge of
the frame.
.TP 15
\fBframe sw\fR
Position the window with its lower-left corner at the lower-left corner
of the frame.
.TP 15
\fBframe w\fR
Position the window with its left edge centered on the left edge of
the frame.
.TP 15
\fBframe nw\fR
Position the window with its upper-left corner at the upper-left corner
of the frame.
.PP
The \fBpack info\fR command may be used to retrieve information about
the packing order for a parent.  It returns a list in the form
.DS C
\fIwindow options window options ...\fR
.DE
Each \fIwindow\fR is a name of a window packed in \fIparent\fR,
and the following \fIoptions\fR describes all of the options for that
window, just as they would be typed to \fBpack append\fR.
The order of the list is the same as the packing order for
\fIparent\fR.
.PP
The packer manages the mapped/unmapped state of all the packed
children windows.  It automatically maps the windows when it packs
them, and it unmaps any windows for which there was no space left
in the cavity.
.PP
The packer makes geometry requests on behalf of the parent windows
it manages.  For each parent window it requests a size large enough
to accommodate all the options specified by all the packed children,
such that zero space would be leftover for \fBexpand\fR options.

.SH KEYWORDS
frame, geometry manager, location, packer, size
