# Bindings for query/replace

if {([bind Text <Control-s>] == "")} {puts "You will also have to load the searchbindings"}

proc undo_replace {t replacements} {
	foreach replacement $replacements {
		eval undo_filter $t $replacement
}}

proc search_same_direction {t f} {
	set direction [lindex [$f.s configure -text] 4]
	global reverse_search_msg reverse_search_failed_msg
	if {($direction == $reverse_search_msg) || ($direction == $reverse_search_failed_msg)} {
		uplevel #0 [bind $f.ss <Control-r>]
	} else {uplevel #0 [bind $f.ss <Control-s>]
}}

# The string to be replaced (it's bound to the replace entry)
set replace_string ""
# Number of replacements made
set replace_count 0

# For undoing replace. Replacements is a list, each entry is a list of three
# items, the starting mark, the ending mark, and the replaced text.
set all_replacements {}
# All the marks used in the current replace operation.
set all_replacement_marks {}

proc replace_one {t f} {
	global replace_string replace_count
	set old_stuff [$t get search.first search.last]
	$t delete search.first search.last
	$t insert insert $replace_string ; incr replace_count
	global modified ; set modified 1

	global all_replacements all_replacement_marks
	set m1 [gensym] ; set m2 [gensym]
	$t mark set $m1 "insert -[string length $replace_string] chars"
	$t mark set $m2 insert
	set replacement [list $m1 $m2 $old_stuff]
	lappend all_replacements $replacement
	lappend all_replacement_marks $m1 $m2

	search_same_direction $t $f
}

proc replace_to_end {t f} {
	while {![catch {$t index search.first}]} {replace_one $t $f}
	exit_search $t $f x
	exit_replace $t $f x
}

proc replace_this_one {t f} {
	if {![catch {$t index search.first}]} {replace_one $t $f
	} else {beep ; 	search_same_direction $t $f
}}

proc exit_replace {t f c} {
	if {![regexp . $c]} {return}
	destroy_f_entry $t $f.r $f.rs
	global replace_count
	flash_label $f -text "Replaced $replace_count occurrences."

	global all_replacements all_replacement_marks
	global search_string replace_string
	register_undoable_cmd $t [list undo_replace $t $all_replacements] "Replace $search_string with $replace_string" $all_replacement_marks
}

# What to display in the Replace label.
set replace_msg "Change to: "

proc replace_setup {t f} {
	global replace_msg replace_string replace_count
	set replace_count 0
	$f.ss configure -width [string length [$f.ss get]]
	create_f_entry $t $f.r $f.rs
	$f.r configure -text $replace_msg
	$f.rs configure -textvariable replace_string

	global all_replacements all_replacement_marks
	set all_replacements {}
	set all_replacement_marks {}

	bind $f.rs <Control-g> "exit_search $t $f x ; exit_replace $t $f x ; beep"
	bind $f.rs <Control-r> [bind $f.ss <Control-r>]
	bind $f.rs <Control-s> [bind $f.ss <Control-s>]
	bind $f.rs <Shift-Find> [bind $f.ss <Shift-Find>]
	bind $f.rs <Find> [bind $f.ss <Find>]
	bind $f.rs <Return> "exit_replace $t $f %A ; exit_search $t $f %A"
	bind $f.rs <Control-c> "replace_this_one $t $f"
	bind $f.rs <Control-C> "replace_to_end $t $f"
	bind $f.rs <Escape> "focus $f.ss"
	bind $t <Escape> "focus $f.rs"
	bind $f.ss <Control-g> "[bind $f.rs <Control-g>]"
	bind $f.ss <Return> "[bind $f.rs <Control-g>]"
}

proc add_replace_bindings {t f} {
	bind $t <Control-C> "replace_setup $t $f"
	bind $t <Control-c> "set replace_string {} ; replace_setup $t $f"
	bind $f.ss <Control-C> "replace_setup $t $f"
	bind $f.ss <Control-c> "set replace_string {} ; replace_setup $t $f"
}


# Replace bindings. f is a frame widget to put messages in.
proc replacebind {f} {
	if {([string first "add_replace_bindings" [bind Text <Control-s>]] \
		 < 0)} {
		bind Text <Control-g> "+ catch \{exit_replace %W $f x\}"
		bind Text <Control-r> "+add_replace_bindings %W $f"
		bind Text <Control-s> "+add_replace_bindings %W $f"
		bind Text <Control-R> "+add_replace_bindings %W $f"
		bind Text <Control-S> "+add_replace_bindings %W $f"
		bind Text <Control-Meta-s> "+add_replace_bindings %W $f"

# Duplicate bindings
		bind Text <Shift-Find> [bind Text <Control-r>]
		bind Text <Find> [bind Text <Control-s>]
}}

replacebind $frame
