#!/afs/ece/usr/tcl/bin/wish -f
# Top-level beth calling routine
# All but last args are config switches:
#	-c controls input (via a global grab)
#	-i iconified (overrides -c)
#	-b browse (instead of edit)
#	-t title (to add to current wm title)
# last arg indicates what to edit/browse:
#	- 	stdin
#	X	X-selection
#	name	file name

# Establish directory beth was called in, and beth's own directory.
set cwd [pwd]
if {([string match /* [info script]])} {
	set beth_dir [file dirname [info script]]
} else {set beth_dir [file dirname $cwd/[info script]]}
cd $beth_dir

if {($argc > 0)} {
	if {![info exists option]} {
		set option [lindex $argv [incr argc -1]]
	}
	if {![info exists configs]} {
		set configs [lrange $argv 0 [incr argc -1]]
}}
if {(![info exists option])} {set option ""}
if {(![info exists configs])} {set configs ""}


if {([string first -i $configs] >= 0)} {wm iconify .
} elseif {([string first -c $configs] >= 0)} {after 1000 {update ; take_control $frame}}
if {([set v [lsearch $configs -t]] >= 0)} {
	set title_comment [lindex $configs [incr v]]
} else {set title_comment {}
}

source widgets.tcl
source dialog.tcl
source entrybind.tcl

# Fill text widget with initial material.
if {($option == "-")} {
	if {[catch {$text insert insert "[read stdin]"}]} {
		flash_label $frame -text "No suitable standard input"
	}
	append wm_name $option
	$text mark set insert 1.0
} elseif {($option == "X")} {
	if {[catch {$text insert insert "[selection get]"}]} {
		flash_label $frame -text "Cannot get X selection"
	}
	append wm_name $option
	$text mark set insert 1.0
} elseif {($option != "")} {
	set name [file tail $option]
	append wm_name $name
	if {([string index $option 0] == "/")} {
		set path [file dirname $option]
	} else {set path $cwd/[file dirname $option]}
	if {[catch {set file [open "$path/$name" r]}]} {
		flash_label $frame -text "New file"
	} else {$text insert insert [read $file]
		close $file
		$text mark set insert 1.0
}} else {set dont_change_title 1
}

if {([string first -b $configs] >= 0)} {
	set edit_flag 0} else {set edit_flag 1}

catch {
if {($edit_flag) && [file exists $path/$name] && ![file writable $path/$name]} {
	set edit_flag 0
	flash_label $frame -text "File is unwritable"
}}

if {![info exists dont_change_title]} {
	if {$edit_flag} {
		wm title . "Edit: $wm_name $title_comment" ; wm iconname . "E $wm_name $title_comment"
	} else {wm title . "Browse: $wm_name $title_comment" ; wm iconname . "B $wm_name $title_comment"
}}

# Cmd to browse the X region
set browse_cmd "beth.tcl -b X"
# Cmd to visit a file (excluding filename)
set visit_cmd "beth.tcl "
# Cmd to view help
set help_cmd "beth.tcl -b HELP"

source browsebind.tcl
source windowbind.tcl
source searchbind.tcl
source interpbind.tcl
source keybind.tcl

if {$edit_flag} {
	source editbind.tcl
	source file.tcl
	source filebind.tcl
	source replacebind.tcl
	catch {set fsBox(name) $name}
	catch {set fsBox(path) $path}
}

if {[file exists $config_file]} {source $config_file}
return "beth ready"
