use v6.d;
use Test;

eval-lives-ok
Q
{
    use FindBin;

    ok MY::<&Bin>,      'Bin exists.';

    ok ! MY::<_FindBin_RESOLVE-DEF >,   'Resolve const Def not installed';
    ok ! MY::<_FindBin_VERBOSE-DEF >,   'Verbose const Def not installed';

    note '# Bin is:    ' ~ Bin;
},
'&Bin is callable';

ok ! MY::<&Bin>,        'Bin is lexicaly scoped.';

ok ! MY::<_FindBin_RESOLVE-DEF >,   'Resolve const Def not installed';
ok ! MY::<_FindBin_VERBOSE-DEF >,   'Verbose const Def not installed';

eval-lives-ok
Q
{
    use FindBin;

    ok MY::<&Script>,   'Script exists.';

    note '# Script is: ' ~ Script;
},
'&Script is callable';

do
{
    use FindBin :Bin;

    ok   MY::<&Bin>,      'Bin exists.';
    ok ! MY::<&Script>,   'Script does not.';
};

ok ! MY::<&Bin>,        'Bin is lexicaly scoped.';
ok ! MY::<&Script>,     'Script is lexicaly scoped.';

do
{
    use FindBin :Script;

    ok   MY::<&Script>,   'Script exists.';
    ok ! MY::<&Bin>,      'Bin does not.';
};

ok ! MY::<&Bin>,        'Bin is lexicaly scoped.';
ok ! MY::<&Script>,     'Script is lexicaly scoped.';

done-testing;
