
package SQL::Admin::Catalog::Object;

use strict;
use warnings;

our $VERSION = v0.5.0;

######################################################################
######################################################################
sub new {                                # ;
    my ($class, %param) = @_;
    my $self = bless {}, ref $class || $class;
    while (my ($k, $v) = each %param) {
        $self->$k ($v);
    }

    ##################################################################

    $self;
}


######################################################################
######################################################################
sub oid {                                # ;
    my $self = shift;
    $self->{oid} = shift if @_ and ! $self->{oid};
    $self->{oid};
}


######################################################################
######################################################################
sub catalog {                            # ;
    my $self = shift;
    $self->{catalog} = shift if @_ and ! $self->{catalog};
    $self->{catalog};
}


######################################################################
######################################################################
sub name {                               # ;
    my $self = shift;
    if (@_) {
        $self->{name} = shift;
        delete $self->{fullname};
    }
    $self->{name};
}


######################################################################
######################################################################
sub schema {                             # ;
    my $self = shift;
    if (@_) {
        $self->{schema} = shift;
        delete $self->{fullname};
    }
    $self->{schema};
}


######################################################################
######################################################################
sub fullname {                           # ;
    my $self = shift;

    $self->{fullname} ||= join '.', grep defined, @$self{qw{ schema name }};
      #map 'ARRAY' eq ref $_ ? @$_ : $_,
}


######################################################################
######################################################################
sub hint {                               # ;
    my $self = shift;
    return $self->{hint} ||= {} unless @_;

    my $key = shift;
    return $self->{hint}{ $key } unless @_;

    $self->{hint}{$key} = shift;
}


######################################################################
######################################################################
sub info {                               # ;
    my $self = shift;

    return unless @_;
    my $key = shift;

    return $self->{info}{ $key } unless @_;

    $self->{info}{ $key } = shift;
}


######################################################################
######################################################################

package SQL::Admin::Catalog::Object;

1;
