signature SOURCEGROUP =
  sig
    val version :real
    type group
    exception CompilingError

    datatype sourceInfo = Source of
      {sourceName     :string,
       targetName     :string,
       group          :group,
       toolName       :string,
       envCurrent     :bool,
       targetCurrent  :bool,
       dependsOn      :string list,
       loadSource     :unit -> unit,
       genTarget      :unit -> unit,
       loadTarget     :unit -> unit,
       checkLoad      :unit -> unit,
       compileSource  :unit -> unit}

    datatype groupDescription =
       Connections of string list  
     | Automatic of string list
     | Library of group list  
     | Include of group list
     | Link of string list

    val create :groupDescription list -> group
    val make :(sourceInfo -> unit) -> group -> unit
    val connections :group -> outstream -> unit
    val updateLibraryAction :group -> (sourceInfo -> unit) -> unit

    val printModifiedSources :bool ref
    val continueAfterError   :bool ref
    val makeLibraries        :bool ref

    structure ToolInternals :TOOL_INTERNALS
  end
