(* Gene Rollins (rollins@cs.cmu.edu)
   School of Computer Science, Carnegie-Mellon Univ., Pittsburgh, PA 15213 *)

functor DataFun
  (structure Hash :HASH
   structure NameRefTable :NAMEREFTABLE
   structure NamespaceTable :NAMESPACETABLE
  ) :DATA = struct

structure Hash = Hash
structure NameRefTable = NameRefTable
structure NamespaceTable = NamespaceTable

type group = int
exception CompilingError
val namespaceSize = 37

datatype sourceInfo = Source of
  {sourceName     :string,
   targetName     :string,
   group          :group,
   toolName       :string,
   envCurrent     :bool,
   targetCurrent  :bool,
   dependsOn      :string list,
   loadSource     :unit -> unit,
   genTarget      :unit -> unit,
   loadTarget     :unit -> unit,
   checkLoad      :unit -> unit,
   compileSource  :unit -> unit}

datatype groupDescription =
   Connections of string list  
 | Automatic of string list
 | Library of group list  
 | Include of group list
 | Link of string list

datatype fileInfo = F of
  {nameH          :string*int,
   toolH          :string*int,
   infoTime       :System.Timer.time ref,
   envObjectTime  :System.Timer.time ref,
   envUpdateTime  :System.Timer.time ref,
   imports        :NameRefTable.t ref,
   exports        :NameRefTable.t ref,
   env'current    :bool ref,
   target'current :bool ref, 
   depends        :(bool*(string*int)) list ref}

datatype groupInfo = G of
  {filetable     :(string, fileInfo) Hash.table ref,
   groupId       :group ref,
   initialized   :int ref,
   namespaces    :NamespaceTable.t ref,
   main'groups   :groupInfo list ref,
   lib'groups    :groupInfo list ref,
   libraryAction :(sourceInfo->unit) ref,
   connFile      :string option ref,
   infoTime      :System.Timer.time ref}
end
