signature RANDOM =
   sig
     val randomlist : int -> int -> real -> int list
   end
 
functor Random() : RANDOM =
    struct
	local 
	    val a = 16807.0  
	    and m = 2147483647.0
	in  
	    fun nextrandom seed =
		let val t = a*seed
		in  t - m * real(floor(t/m))  end
	    
	    and truncto k r = 1 + floor((r / m) * (real k))
	end
    
	fun randlist (n,seed,seeds) =
	    if n=0 then seeds  
	    else randlist(n-1, nextrandom seed, seed::seeds);

	fun randomlist high n seed =
	    map (truncto high) (randlist (n,seed,[]))
    end
